#!/usr/bin/env python

'''
Created on 23/07/2012


    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

Clase con la interfaz grafica utilizando las librerias pygame y el main

@author: Andros Fenollosa
@contact: correoandros@gmail.com
'''

import pygame, sys, time
from pygame.locals import *
from Dominio import Dominio_class

class Main (object):
    # -----------
    # Constantes
    # -----------
    
    
    
    # ------------------------------
    # Clases y Funciones utilizadas
    # ------------------------------
    def __init__(self):
        self.main()
    
    # ------------------------------
    # Funcion principal del juego
    # ------------------------------
    
    
    def main():
        SCREEN_WIDTH = 800
        SCREEN_HEIGHT = 480
        sUrlRutaMaemo = ""
        pulsaTiemp = 0.3
        numImgX = 515
        numImgY1 = 170
        numImgY2 = 210
        numImgY3 = 248
        pygame.init()
        
        miDom = Dominio_class()
        miDom.start()
        
        #screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
        
        screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT),pygame.FULLSCREEN)
        pygame.mouse.set_visible(False)
        sUrlRutaMaemo = miDom.sUrlRutaMaemo;
        
        pygame.display.set_caption("SimonKM")
        
        # cargamos el fondo y una imagen (se crea objetos "Surface")
        fondo = pygame.image.load(sUrlRutaMaemo + "img/plantilla.jpg").convert()
        imgLogros = pygame.image.load(sUrlRutaMaemo + "img/logros.png").convert_alpha()
        botonAmarillo = pygame.image.load(sUrlRutaMaemo + "img/amarillo.png").convert_alpha()
        botonAzul = pygame.image.load(sUrlRutaMaemo + "img/azul.png").convert_alpha()
        botonSalir = pygame.image.load(sUrlRutaMaemo + "img/exit.png").convert_alpha()
        botonRojo = pygame.image.load(sUrlRutaMaemo + "img/rojo.png").convert_alpha()
        botonStart = pygame.image.load(sUrlRutaMaemo + "img/start.png").convert_alpha()
        botonVerde = pygame.image.load(sUrlRutaMaemo + "img/verde.png").convert_alpha()
        botonVerdeClick = pygame.image.load(sUrlRutaMaemo + "img/verdeClick.png").convert_alpha()
        botonAmarilloClick = pygame.image.load(sUrlRutaMaemo + "img/amarilloClick.png").convert_alpha()
        botonRojoClick = pygame.image.load(sUrlRutaMaemo + "img/rojoClick.png").convert_alpha()
        botonAzulClick = pygame.image.load(sUrlRutaMaemo + "img/azulClick.png").convert_alpha()
        botonStartClick = pygame.image.load(sUrlRutaMaemo + "img/startClick.png").convert_alpha()
        imgNum0 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-0.png").convert_alpha()
        imgNum1 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-1.png").convert_alpha()
        imgNum2 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-2.png").convert_alpha()
        imgNum3 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-3.png").convert_alpha()
        imgNum4 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-4.png").convert_alpha()
        imgNum5 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-5.png").convert_alpha()
        imgNum6 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-6.png").convert_alpha()
        imgNum7 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-7.png").convert_alpha()
        imgNum8 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-8.png").convert_alpha()
        imgNum9 = pygame.image.load(sUrlRutaMaemo + "img/nums/num-9.png").convert_alpha()
        
        #Redibuja
        while True:
            screen.blit(fondo, (0, 0))
            screen.blit(botonAzul, (0, 0))
            screen.blit(botonSalir, (0, 0))
            screen.blit(botonRojo, (0, 0))
            screen.blit(botonStart, (0, 0))
            screen.blit(botonVerde, (0, 0))
            screen.blit(botonAmarillo, (0, 0))
                    
            #Record
            screen.blit(vars()["imgNum" + str(miDom.numRecordJugadorPart1)], (numImgX, numImgY1))
            screen.blit(vars()["imgNum" + str(miDom.numRecordJugadorPart2)], (numImgX, numImgY2))
            screen.blit(vars()["imgNum" + str(miDom.numRecordJugadorPart3)], (numImgX, numImgY3))
                
            screen.blit(imgLogros, (miDom.tarjLoPosX, 0))
            
            if miDom.bLogrosDespl == False:
                if miDom.bVerde == True:
                    screen.blit(botonVerdeClick, (0, 0))
                    pygame.display.flip()
                    time.sleep(pulsaTiemp)
                    miDom.bVerde = False
                if miDom.bAmarillo == True:
                    screen.blit(botonAmarilloClick, (0, 0))
                    pygame.display.flip()
                    time.sleep(pulsaTiemp)
                    miDom.bAmarillo = False
                if miDom.bRojo == True:
                    screen.blit(botonRojoClick, (0, 0))
                    pygame.display.flip()
                    time.sleep(pulsaTiemp)
                    miDom.bRojo = False
                if miDom.bAzul == True:
                    screen.blit(botonAzulClick, (0, 0))
                    pygame.display.flip()
                    time.sleep(pulsaTiemp)
                    miDom.bAzul = False
                if miDom.bStart == True:
                    screen.blit(botonStartClick, (0, 0))
                    pygame.display.flip()
                    time.sleep(pulsaTiemp)
                    miDom.bStart = False
                
            pygame.display.flip()
        
            # Posibles entradas del teclado y mouse
            for event in pygame.event.get():
                if event.type == pygame.QUIT:
                    sys.exit()
                elif event.type == MOUSEBUTTONDOWN:
                    if event.button == 1:
                        #Comprueba si se ha pulsado el boton verde
                        if pygame.mouse.get_pos()[0] >= 50 and pygame.mouse.get_pos()[0] <= 252 and pygame.mouse.get_pos()[1] >= 252 and pygame.mouse.get_pos()[1] <= 460:
                            if miDom.bLogrosDespl == False:
                                miDom.bVerde = True
                                miDom.recogerBoton("pushVerde")
                        #Amarillo
                        elif pygame.mouse.get_pos()[0] >= 279 and pygame.mouse.get_pos()[0] <= 482 and pygame.mouse.get_pos()[1] >= 251 and pygame.mouse.get_pos()[1] <= 458:
                            if miDom.bLogrosDespl == False:
                                miDom.bAmarillo = True
                                miDom.recogerBoton("pushAmarillo")
                        #Azul
                        elif pygame.mouse.get_pos()[0] >= 279 and pygame.mouse.get_pos()[0] <= 482 and pygame.mouse.get_pos()[1] >= 27 and pygame.mouse.get_pos()[1] <= 230:
                            if miDom.bLogrosDespl == False:
                                miDom.bAzul = True
                                miDom.recogerBoton("pushAzul")
                        #Rojo
                        elif pygame.mouse.get_pos()[0] >= 50 and pygame.mouse.get_pos()[0] <= 252 and pygame.mouse.get_pos()[1] >= 24 and pygame.mouse.get_pos()[1] <= 230:
                            if miDom.bLogrosDespl == False:
                                miDom.bRojo = True
                                miDom.recogerBoton("pushRojo")
                        #Start
                        elif pygame.mouse.get_pos()[0] >= 674 and pygame.mouse.get_pos()[0] <= 763 and pygame.mouse.get_pos()[1] >= 58 and pygame.mouse.get_pos()[1] <= 144:
                            if miDom.bLogrosDespl == False:
                                miDom.bStart = True
                                miDom.recogerBoton("pushButton")
                        #Desplegar logros
                        elif pygame.mouse.get_pos()[0] >= 747 and pygame.mouse.get_pos()[0] <= 800 and pygame.mouse.get_pos()[1] >= 175 and pygame.mouse.get_pos()[1] <= 302 and miDom.bLogrosDespl == False:
                            if miDom.bLogrosDespl == False:
                                miDom.bLogrosSub = True
                                miDom.recogerBoton("pushLogroDesplegar")
                        #Repliega logros
                        elif pygame.mouse.get_pos()[0] >= 0 and pygame.mouse.get_pos()[0] <= 50 and pygame.mouse.get_pos()[1] >= 175 and pygame.mouse.get_pos()[1] <= 302 and miDom.bLogrosDespl == True:
                            miDom.bLogrosBaj = True
                            miDom.recogerBoton("pushLogroReplegar")
                        elif pygame.mouse.get_pos()[0] >= 672 and pygame.mouse.get_pos()[0] <= 762 and pygame.mouse.get_pos()[1] >= 337 and pygame.mouse.get_pos()[1] <= 426:
                            if miDom.bLogrosDespl == False:
                                sys.exit()
                            
    if __name__ == "__main__":
        main()
