#include "scheduledlist.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QTreeView>
#include <QPushButton>
#include <QLabel>

ScheduledList::ScheduledList(QStandardItemModel *scheduled,
                             QWidget *parent)
        : QWidget (parent)
{
        setWindowTitle(tr("Scheduled Expenses"));
        setAttribute(Qt::WA_Maemo5StackedWindow);
        setAttribute(Qt::WA_DeleteOnClose);
        setWindowFlags(windowFlags() | Qt::Window);

        QVBoxLayout *layout = new QVBoxLayout (this);

        QPushButton *newButton = new QPushButton(tr("New"));
        layout->addWidget(newButton, 0);
        connect(newButton, SIGNAL(clicked()), this, SIGNAL(newScheduledSelected()));

        QTreeView *tree = new QTreeView();
        tree->setModel(scheduled);
        tree->setProperty("FingerScrollable", true);
        tree->setColumnHidden(0, true);
        tree->setColumnHidden(4, true);
        tree->setColumnHidden(5, true);
        tree->setColumnWidth(1, 50);
        tree->setColumnWidth(2, 100);
        tree->setColumnWidth(3, 200);
        tree->setHeaderHidden(true);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SIGNAL(scheduledDetailsSelected(QModelIndex)));
}

ScheduledList::~ScheduledList()
{
}
