#ifndef CONCEPTDETAILSDIALOG_H
#define CONCEPTDETAILSSDIALOG_H

#include <QDialog>
#include <QStandardItemModel>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include "concept.h"

class ConceptDetailsDialog : public QDialog
{
        Q_OBJECT
 public:
        ConceptDetailsDialog(QStandardItemModel *concepts,
                             int row,
                             QWidget *parent = 0,
                             Qt::WindowFlags f = 0);
        ConceptDetailsDialog(QWidget *parent = 0,
                             Qt::WindowFlags f = 0);

 signals:
        void newConceptConfirmed(Concept *c);
        void updateConceptConfirmed(Concept *c);
        void deleteConceptConfirmed(Concept *c);

 private slots:
        void saveClicked();
        void deleteClicked();
        void newClicked();

 private:
        QLineEdit *_name;
        QLineEdit *_price;
        QDialogButtonBox *box;
        int _row;
        QString conceptName;
};
#endif
