#include "accountsdialog.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QListView>
#include <QPushButton>

AccountsDialog::AccountsDialog(QStandardItemModel *accounts,
                               QWidget *parent,
                               Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Accounts"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QListView *list = new QListView();
        list->setModel(accounts);
        list->setModelColumn(1);
        list->setProperty("FingerScrollable", true);
        layout->addWidget(list, 1);

        connect (list, SIGNAL(activated(const QModelIndex&)),
                 this, SLOT(detailsSelected(const QModelIndex&)));

        QDialogButtonBox *box = new QDialogButtonBox();
        box->addButton(new QPushButton(tr("New")), QDialogButtonBox::AcceptRole);
        box->addButton(QDialogButtonBox::Cancel);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(newSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

AccountsDialog::~AccountsDialog()
{
}

void AccountsDialog::newSelected()
{
        accept();
        emit newAccountSelected();
}

void AccountsDialog::detailsSelected(const QModelIndex &index)
{
        accept();
        emit accountDetailsSelected(index);
}
