#ifndef ACCOUNTDETAILSDIALOG_H
#define ACCOUNTDETAILSSDIALOG_H

#include <QDialog>
#include <QStandardItemModel>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include "account.h"

class AccountDetailsDialog : public QDialog
{
        Q_OBJECT
 public:
        AccountDetailsDialog(QStandardItemModel *accounts,
                             int row,
                             QWidget *parent = 0,
                             Qt::WindowFlags f = 0);
        AccountDetailsDialog(QWidget *parent = 0,
                             Qt::WindowFlags f = 0);

 signals:
        void newAccountConfirmed(Account *a);
        void updateAccountConfirmed(Account *a);
        void deleteAccountConfirmed(Account *a);
        void selectAccountConfirmed(Account *a);

 private slots:
        void saveClicked();
        void deleteClicked();
        void newClicked();
        void activateClicked();

 private:
        QLineEdit *_name;
        QLineEdit *_budget;
        QDialogButtonBox *box;
        int _row;
        double accountBudget;
        QString accountName;
        int accountId;
};
#endif
