#include "accountdetailsdialog.h"
#include <QHBoxLayout>
#include <QFormLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QPushButton>
#include <QMaemo5InformationBox>

AccountDetailsDialog::AccountDetailsDialog(QStandardItemModel *accounts,
                                           int row,
                                           QWidget *parent,
                                           Qt::WindowFlags f)
        : QDialog (parent, f)
{
        _row = row;
        setWindowTitle(tr("Account details"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 0);

        accountId = accounts->item(row, 0)->text().toInt();
        accountName = accounts->item(row, 1)->text();
        accountBudget = accounts->item(row, 2)->text().toDouble();

        QLabel *name = new QLabel();
        name->setText(accountName);
        form->addRow (new QLabel(tr("Name")), name);

        _budget = new QLineEdit();
        _budget->setText(accounts->item(row, 2)->text());
        form->addRow (new QLabel(tr("Default budget")), _budget);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *activateButton = new QPushButton(tr("Select"));
        box->addButton(activateButton, QDialogButtonBox::ActionRole);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        QPushButton *deleteButton = new QPushButton(tr("Delete"));
        box->addButton(deleteButton, QDialogButtonBox::ActionRole);

        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteClicked()));
        connect(activateButton, SIGNAL(clicked()), this, SLOT(activateClicked()));
}

AccountDetailsDialog::AccountDetailsDialog(QWidget *parent,
                                           Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Create new account"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 1);

        _name = new QLineEdit();
        form->addRow (new QLabel(tr("Name")), _name);
        _budget = new QLineEdit();
        form->addRow (new QLabel(tr("Default budget")), _budget);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(newClicked()));
}

void AccountDetailsDialog::saveClicked()
{
        if (_budget->text() == "") {
                QMaemo5InformationBox::information(this, tr("Default budget cannot be empty"));
                return;
        }

        double budget = _budget->text().toDouble();

        if (budget <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid budget format"));
                return;
        }

        emit updateAccountConfirmed(new Account(accountId, accountName, budget));

        accept();
}

void AccountDetailsDialog::deleteClicked()
{
        accept();
        emit deleteAccountConfirmed(new Account(accountId,"",0));
}

void AccountDetailsDialog::activateClicked()
{
        accept();
        emit selectAccountConfirmed(new Account(accountId,accountName,accountBudget));
}

void AccountDetailsDialog::newClicked()
{
        if (_name->text() == "") {
                QMaemo5InformationBox::information(this, tr("Name field cannot be empty"));
                return;
        }

        if (_budget->text() == "") {
                QMaemo5InformationBox::information(this, tr("Default budget cannot be empty"));
                return;
        }

        double budget = _budget->text().toDouble();

        if (budget <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid budget format"));
                return;
        }

        emit newAccountConfirmed(new Account(0,_name->text(), budget));

        accept();
}
