#include "videofile.h"

VideoFile::VideoFile( QFileInfo file, QObject* parent ) :
    QObject( parent ),
    m_file( file ),
    m_currentPosTenthOfASec( 0 )
{
}

VideoFile::VideoFile( QFileInfo file, unsigned int resumePosTenthOfASec, QObject* parent ) :
    QObject( parent ),
    m_file( file ),
    m_currentPosTenthOfASec( resumePosTenthOfASec )
{
}


QFileInfo VideoFile::file() const
{
    return m_file;
}

void VideoFile::setResumePos( unsigned int tenthOfASec ) {
    m_currentPosTenthOfASec = tenthOfASec;
}

unsigned int VideoFile::resumePos() const {
    return m_currentPosTenthOfASec;
}

bool VideoFile::nameAscCmp( const VideoFile* a, const VideoFile* b )
{
    return a->file().fileName().toCaseFolded() < b->file().fileName().toCaseFolded();
}

bool VideoFile::nameDesCmp( const VideoFile* a, const VideoFile* b )
{
    return a->file().fileName().toCaseFolded() > b->file().fileName().toCaseFolded();
}

bool VideoFile::sizeAscCmp( const VideoFile* a, const VideoFile* b )
{
    if ( a->file().size() == b->file().size() ) {
        return nameAscCmp( a, b );
    }
    return a->file().size() < b->file().size();
}

bool VideoFile::sizeDesCmp( const VideoFile* a, const VideoFile* b )
{
    if ( a->file().size() == b->file().size() ) {
        return nameAscCmp( a, b );
    }
    return a->file().size() > b->file().size();
}

bool VideoFile::resumeAscCmp( const VideoFile* a, const VideoFile* b )
{
    if ( a->resumePos() == b->resumePos() ) {
        return nameAscCmp( a, b );
    }
    return a->resumePos() < b->resumePos();
}

bool VideoFile::resumeDesCmp( const VideoFile* a, const VideoFile* b )
{
    if ( a->resumePos() == b->resumePos() ) {
        return nameAscCmp( a, b );
    }
    return a->resumePos() > b->resumePos();
}
