#include <QToolButton>
#include <QListWidget>
#include <QScrollArea>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QDebug>

#include "infoaccess.h"
#include "settings.h"
#include "region.h"

RegionWindow::RegionWindow(QMainWindow *parent) : SettingsWindow(parent), FLAGPATH("/opt/showtime/flags/")
{
	setWindowTitle("SELECT REGION");
	QScrollArea *scroll = new QScrollArea(this);
	QWidget *widget = new QWidget(this);
	
	MyToolButton *ukButton = new MyToolButton(QIcon(QString(FLAGPATH) + "uk.png"), "UK", this);
	MyToolButton *auButton = new MyToolButton(QIcon(QString(FLAGPATH) + "au.png"), "AU", this);
	MyToolButton *nzButton = new MyToolButton(QIcon(QString(FLAGPATH) + "nz.png"), "NZ", this);
	MyToolButton *seButton = new MyToolButton(QIcon(QString(FLAGPATH) + "se.png"), "SE", this);
	MyToolButton *deButton = new MyToolButton(QIcon(QString(FLAGPATH) + "de.png"), "DE", this);
	MyToolButton *frButton = new MyToolButton(QIcon(QString(FLAGPATH) + "fr.png"), "FR", this);
	MyToolButton *esButton = new MyToolButton(QIcon(QString(FLAGPATH) + "es.png"), "ES", this);
	MyToolButton *itButton = new MyToolButton(QIcon(QString(FLAGPATH) + "it.png"), "IT", this);
	MyToolButton *hrButton = new MyToolButton(QIcon(QString(FLAGPATH) + "hr.png"), "HR", this);
	MyToolButton *siButton = new MyToolButton(QIcon(QString(FLAGPATH) + "si.png"), "SI", this);
	MyToolButton *dkButton = new MyToolButton(QIcon(QString(FLAGPATH) + "dk.png"), "DK", this);
	MyToolButton *nlButton = new MyToolButton(QIcon(QString(FLAGPATH) + "nl.png"), "NL", this);
	MyToolButton *beButton = new MyToolButton(QIcon(QString(FLAGPATH) + "be.png"), "BE", this);
	MyToolButton *noButton = new MyToolButton(QIcon(QString(FLAGPATH) + "no.png"), "NO", this);
	MyToolButton *ruButton = new MyToolButton(QIcon(QString(FLAGPATH) + "ru.png"), "RU", this);
	MyToolButton *myButton = new MyToolButton(QIcon(QString(FLAGPATH) + "my.png"), "MY", this);
	MyToolButton *zaButton = new MyToolButton(QIcon(QString(FLAGPATH) + "za.png"), "ZA", this);
	MyToolButton *plButton = new MyToolButton(QIcon(QString(FLAGPATH) + "pl.png"), "PL", this);
	MyToolButton *fiButton = new MyToolButton(QIcon(QString(FLAGPATH) + "fi.png"), "FI", this);

	QGridLayout *finallayout = new QGridLayout;
	finallayout->addWidget(ukButton,0,0);
	finallayout->addWidget(auButton,0,1);
	finallayout->addWidget(nzButton,0,2);
	finallayout->addWidget(seButton,1,0);
	finallayout->addWidget(deButton,1,1);
	finallayout->addWidget(frButton,1,2);
	finallayout->addWidget(esButton,2,0);
	finallayout->addWidget(itButton,2,1);
	finallayout->addWidget(hrButton,2,2);
	finallayout->addWidget(siButton,3,0);
	finallayout->addWidget(dkButton,3,1);
	finallayout->addWidget(nlButton,3,2);
	finallayout->addWidget(beButton,4,0);
	finallayout->addWidget(noButton,4,1);
	finallayout->addWidget(ruButton,4,2);
	finallayout->addWidget(myButton,5,0);
	finallayout->addWidget(zaButton,5,1);
	finallayout->addWidget(plButton,5,2);
	finallayout->addWidget(fiButton,6,0);

	widget->setLayout(finallayout);

	scroll->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	scroll->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	scroll->setWidget(widget);	
	scroll->setAlignment(Qt::AlignHCenter);	
	scroll->setWidgetResizable(true);
	setCentralWidget(scroll);
	
	connect(ukButton, SIGNAL(clicked()), this, SLOT(setUK()));
	connect(auButton, SIGNAL(clicked()), this, SLOT(setAU()));
	connect(nzButton, SIGNAL(clicked()), this, SLOT(setNZ()));
	connect(seButton, SIGNAL(clicked()), this, SLOT(setSE()));
	connect(deButton, SIGNAL(clicked()), this, SLOT(setDE()));
	connect(frButton, SIGNAL(clicked()), this, SLOT(setFR()));
	connect(esButton, SIGNAL(clicked()), this, SLOT(setES()));
	connect(itButton, SIGNAL(clicked()), this, SLOT(setIT()));
	connect(hrButton, SIGNAL(clicked()), this, SLOT(setHR()));
	connect(siButton, SIGNAL(clicked()), this, SLOT(setSI()));
	connect(dkButton, SIGNAL(clicked()), this, SLOT(setDK()));
	connect(nlButton, SIGNAL(clicked()), this, SLOT(setNL()));
	connect(beButton, SIGNAL(clicked()), this, SLOT(setBE()));
	connect(noButton, SIGNAL(clicked()), this, SLOT(setNO()));
	connect(ruButton, SIGNAL(clicked()), this, SLOT(setRU()));
	connect(myButton, SIGNAL(clicked()), this, SLOT(setMY()));
	connect(zaButton, SIGNAL(clicked()), this, SLOT(setZA()));
	connect(plButton, SIGNAL(clicked()), this, SLOT(setPL()));
	connect(fiButton, SIGNAL(clicked()), this, SLOT(setFI()));
	
	loadSettings();
}

void RegionWindow::setRegion(QString region)
{
	SettingsWindow::setRegion(region);
	updateSettings();
	emit clicked();
}

void RegionWindow::setUK()
{
	setRegion("UK");
}
void RegionWindow::setAU()
{
    setRegion("AU");
}
void RegionWindow::setNZ()
{
    setRegion("NZ");
}
void RegionWindow::setSE()
{
    setRegion("SE");
}
void RegionWindow::setDE()
{
    setRegion("DE");
}
void RegionWindow::setFR()
{
    setRegion("FR");
}
void RegionWindow::setES()
{
    setRegion("ES");
}
void RegionWindow::setIT()
{
    setRegion("IT");
}
void RegionWindow::setHR()
{
    setRegion("HR");
}
void RegionWindow::setSI()
{
    setRegion("SI");
}
void RegionWindow::setDK()
{
    setRegion("DK");
}
void RegionWindow::setNL()
{
    setRegion("NL");
}
void RegionWindow::setBE()
{
    setRegion("BE");
}
void RegionWindow::setNO()
{
    setRegion("NO");
}
void RegionWindow::setRU()
{
    setRegion("RU");
}
void RegionWindow::setMY()
{
    setRegion("MY");
}
void RegionWindow::setZA()
{
    setRegion("ZA");
}
void RegionWindow::setPL()
{
    setRegion("PL");
}
void RegionWindow::setFI()
{
    setRegion("FI");
}


RegionWindow::~RegionWindow()
{
}
