#ifndef NOFILES_H
#define NOFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class NOFiles : public DataDownloader
{
    Q_OBJECT

public:
    NOFiles( QObject *parent );
    virtual ~NOFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	void sendRecordMsg(QStringList data);
	virtual bool isSingleXMLTVFile() { return false; }

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;
};

#endif // NOFILES_H
