#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "nofiles.h"

NOFiles::NOFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/no/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".no");
	_channelFile = QString(DATAPATH) + ".no_channel_list";
	initSettings();
}

void NOFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to NO
	DataDownloader::initSettings();
}

QUrl NOFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://epg.mspc.no/xmltv/%1_%2?APP=SHOWTIME").arg(requestChannelCode).arg(_requestDate.toString("yyyy-MM-dd")) );
	else
		url.setPath(QString(""));

	return url;
}

NOFiles::~NOFiles()
{
}

QString NOFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void NOFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void NOFiles::sendRecordMsg(QStringList data)
{
}

void NOFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
