#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "hrfiles.h"

HRFiles::HRFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/hr/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".hr");
	_channelFile = QString(DATAPATH) + ".hr_channel_list";
	initSettings();
}

void HRFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to HR
	DataDownloader::initSettings();
}

QUrl HRFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://tvprofil.net/xmltv/data/%2/%1_%2_tvprofil.net.xml?APP=SHOWTIME")
                                                            .arg(_requestDate.toString("yyyy-MM-dd")).arg(requestChannelCode) );
	else
		url.setPath(QString(""));

	return url;
}

HRFiles::~HRFiles()
{
}

QString HRFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void HRFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void HRFiles::sendRecordMsg(QStringList data)
{
}

void HRFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
