#ifndef UKFILES_H
#define UKFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class UKFiles : public DataDownloader
{
    Q_OBJECT

public:
    UKFiles( QObject *parent );
    virtual ~UKFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void updateSettingsFile();
	virtual void checkDataStatus();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList();
	void sendRecordMsg(QStringList data);

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();
	void prepareUrl();

private:
	QProcess *_processPtr;
	const char* HELPERPATH;
};

#endif // UKFILES_H
