#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QStandardItemModel>
#include <QPushButton>
#include <QListWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QFile>
#include <QDebug>

#include "infoaccess.h"
#include "settings.h"
#include "region.h"
#include "favourite.h"

FavouriteWindow::FavouriteWindow(QMainWindow *parent) : SettingsWindow(parent)
{
	setWindowTitle("FAVOURITES");
	_mainwidget = new QWidget(this);

	_regionListModel = new QStandardItemModel(this);
	_regionSelectorList = new QMaemo5ListPickSelector(this);
	_regionSelectorList->setModel(_regionListModel);

	_regionSelector = new QMaemo5ValueButton("PICK REGION", this);
	_regionSelector->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
	_regionSelector->setPickSelector(_regionSelectorList);

	_channelListModel = new QStandardItemModel(this);

	_channelSelector = new QMaemo5ValueButton("PICK CHANNELS", this);
	_channelSelector->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);

	_selectedListWidget = new QListWidget(this);	

	_cancelButton = new QPushButton("CANCEL", this);
	_saveButton = new QPushButton("SAVE", this);

	_h1layout = new QHBoxLayout;
	_h2layout = new QHBoxLayout;
	_h3layout = new QHBoxLayout;
	_v1layout = new QVBoxLayout;

	_h1layout->addWidget(_regionSelector);
	_h1layout->addWidget(_channelSelector);
	_h2layout->addWidget(_selectedListWidget);
	_h3layout->addWidget(_cancelButton);
	_h3layout->addWidget(_saveButton);

	_v1layout->addLayout(_h1layout);
	_v1layout->addLayout(_h2layout);
	_v1layout->addLayout(_h3layout);
	
	_mainwidget->setLayout(_v1layout);

	setCentralWidget(_mainwidget);

	initRegionListModel();
	loadSettings(); // load from the file what is there currently

	connect(_regionSelectorList, SIGNAL(selected(QString)), this, SLOT(selectRegion(QString)));
	connect(_cancelButton, SIGNAL(clicked()), this, SLOT(doCancel()));
	connect(_saveButton, SIGNAL(clicked()), this, SLOT(doSave()));
	connect(_selectedListWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(removeChannel(QListWidgetItem*)));
}

void FavouriteWindow::initRegionListModel()
{
	_regionListModel->clear();
	getSettingsMap().clear(); 

	RegionWindow *r = new RegionWindow(this);
	QStringList regionList = r->getRegionList();

	//////////////////////////////////////////////////////
	// REGION SELECTOR LIST 
	//////////////////////////////////////////////////////
	foreach(QString region, regionList)
	{
		QStandardItem *regionitem = new QStandardItem(region);
		regionitem->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
		regionitem->setEditable(false); // prevent editing of the item
		_regionListModel->appendRow(regionitem);
		
	}
}

void FavouriteWindow::initChannelListModel()
{
	//////////////////////////////////////////////////////
	// CHANNEL SELECTOR LIST 
	//////////////////////////////////////////////////////
	_channelListModel->clear();

	_channelSelectorList = new QMaemo5ListPickSelector(this);
	_channelSelectorList->setModel(_channelListModel);
	_channelSelector->setPickSelector(_channelSelectorList);
	connect(_channelSelectorList, SIGNAL(selected(QString)), this, SLOT(selectChannel(QString)));

	QStringList channelList = _infoapi->getChannelList();

	foreach(QString channel, channelList)
	{
		QStandardItem *item = new QStandardItem(channel);
		item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
		item->setEditable(false); // prevent editing of the item
		_channelListModel->appendRow(item);
	}
}

void FavouriteWindow::selectRegion(QString region)
{
	_infoapi = new InfoAccess(this, region);
	_region = region;
	initChannelListModel();  // init the channel list for the selected region
	showSelectedListWidget(); // load the current favourites of the region selected
}

void FavouriteWindow::selectChannel(QString channel)
{
	//qDebug() << "Adding " << channel << " as your favourite";

	if ( getFavourites(_region).contains(channel) )
	{
		//qDebug() << channel << " is already a favourite";
		return;
	}
	else
		setFavourites(_region, channel);

	//qDebug() << getSettingsMap();

	_selectedListWidget->addItem(channel);
}

void FavouriteWindow::showSelectedListWidget()
{
	_selectedListWidget->clear();

	foreach(QString channel, getFavourites(_region))
		_selectedListWidget->addItem(channel);
}

void FavouriteWindow::removeChannel(QListWidgetItem* item)
{
	//qDebug() << "Removing " << item->text() << " from favourites";

	removeFromFavourite(_region, item->text());
	_selectedListWidget->removeItemWidget(item);

	//qDebug() << getSettingsMap();

	showSelectedListWidget();
}

void FavouriteWindow::doSave()
{
	updateSettings();
	emit clicked(); // CLOSE THE WINDOW
}

void FavouriteWindow::doCancel()
{
	emit clicked(); // CLOSE THE WINDOW
}

FavouriteWindow::~FavouriteWindow()
{
}
