#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "esfiles.h"

ESFiles::ESFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/es/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".es");
	initSettings();
}

void ESFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to ES(germany)
	DataDownloader::initSettings();
}

QUrl ESFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://tvprofil.net/xmltv/data/%2/%1_%2_tvprofil.net.xml?APP=SHOWTIME")
                                                            .arg(QDate::currentDate().toString("yyyy-MM-dd")).arg(requestChannelCode) );
	else
		url.setPath(QString(""));

	return url;
}

ESFiles::~ESFiles()
{
}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void ESFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".es");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << '#' << date; 

		s << endl;
	}

	_settingsFile->close();
}

void ESFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap[_requestChannel].contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
	}
}

QString ESFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

QStringList ESFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".es_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QStringList line = textStream.readLine().split('#');
			
			QString channelname = line[0];
			QString channelcode = line[1];

			_channelCodeMap[channelname] = channelcode;
		}

		return _channelCodeMap.keys();
	}
	
	return channellist;
}

void ESFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void ESFiles::sendRecordMsg(QStringList data)
{
}

void ESFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
