#ifndef INFOACCESS_H
#define INFOACCESS_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QMap>
#include <QUrl>
#include "datadownloader.h"

class QNetworkReply;
class DataDownloader;

struct ChannelData
{
    QString channelId;
    QString date;
    QString sdate;
    QString stime;
    QString edate;
    QString etime;
	QString title;
    QString type;
    QString desc;
};

class InfoAccess : public QObject
{
    Q_OBJECT

public:
    InfoAccess( QObject *parent, QString region="UK");
	void clear();
    virtual ~InfoAccess();
	void setUrl(QUrl url);
    QMap<QString, QList<ChannelData> > results() const;
	QStringList getChannelList();
	void sendRecordMsg(QStringList input);
    bool processXMLTV( QString filename );

signals:
    void finished( bool success );

public slots:
    bool getChannelInfo(DownloadInput& input);

private slots:
	void finishedDownload( QNetworkReply *reply );

private:
    bool processXMLTV();
    void downloadXMLTV();

    struct InfoAccessPrivate *d;
	DataDownloader *dataDownloader;

	QString	_currentChannel;

	QString _region;
};

#endif // INFOACCESS_H
