#!/usr/bin/env python
###########################################################################
# Name: 	ShipsRolling
# Description:	Shows the rolling of a moving ship in degrees.
#		                Angles are visualised in a graph
# Copyright:	George Ruinelli, caco3@ruinelli.ch
# Last change:	26. June 2010
# Licence:	GPL
###########################################################################

import sys
import os
import random
from PyQt4 import QtGui, QtCore
import time
from time import strftime
import math
import array

from Ui_GUI import *
from Ui_Info import *



###########################################################################
# Some parameters
###########################################################################
version="1.0.4 (20100626)"
logfolder="/home/user/MyDocs/" #users home dir
smoothing=50
arrayDataLen=780
 
 

###########################################################################
# Function to measure used time in a function
###########################################################################
def Show_passed_time(text=""):
  global passed_time
  
  now=time.time()
  t=1000*(now-passed_time)
  print str(int(t)), "ms: ", text
  
  passed_time = time.time()
 


###########################################################################
# Function to reset indication of max. angles
###########################################################################
def actionResetMaxAngles():
  global arrOldAngles
  
  arrOldAngles[0][0]=0 #Alpha
  arrOldAngles[0][1]=0
  arrOldAngles[1][0]=0 #Beta
  arrOldAngles[1][1]=0
  #arrOldAngles[2][0]=0 #Gama
  #arrOldAngles[2][1]=0
  
  ui.txtAngleA_Max.setText("0")
  ui.txtAngleA_Max_2.setText("0")
  ui.txtAngleB_Max.setText("0")
  ui.txtAngleB_Max_2.setText("0")
  #ui.txtAngleC_Max.setText("0")
  #ui.txtAngleC_Max_2.setText("0")  
  
 
 
 
###########################################################################
# Function to set angle to zero in any phone position
###########################################################################
def actionSetAccCorrection():
  global arrAccCorrection, arrData, arr
  global Use_own_Calibration
  
  if(Use_own_Calibration==0):
    Use_own_Calibration=1
    ui.actionCalibrate_Sensor.setChecked(True)
    
    arrAccCorrection[0]=arrData[0][arrayDataIndex] #set to current data, X
    arrAccCorrection[1]=arrData[1][arrayDataIndex] # Y
    arrAccCorrection[2]=arrData[2][arrayDataIndex] - 1000 #Z
  else: #reset to normal zero point
    Use_own_Calibration=0
    ui.actionCalibrate_Sensor.setChecked(False)
    
    arrAccCorrection[0]=0
    arrAccCorrection[1]=0
    arrAccCorrection[2]=0


 
 
###########################################################################
# Function to clear graph
###########################################################################
def actionResetGraph():
  global arrData, arrayDataLen
  
  for i in range(0, arrayDataLen): arrData[3][i]=0 # clears angle values in array


 
 
###########################################################################
# Shows some copyright infos
###########################################################################
def actionInfo():
  ui1.lversion.setText(version)
  Info.show()




###########################################################################
# Function to open or close the log file
###########################################################################
def actionStartStopLog():
  global WriteLog, logfile,logfolder

  if(WriteLog==0):    #start log    
    #open file, write header
    t=strftime("%d-%b-%Y_%H-%M-%S", time.localtime())
    filename=logfolder+"ShipRolling_"+t+".csv"
    logfile = open(filename, 'w')
    print "Created logfile "+filename
    d="Date/Time, AccX, AccY, AccZ, AngleA, AngleB"
    logfile.write(d+"\n") #Print file header
    
    WriteLog=1
    ui.actionStart_writing_data_to_file.setChecked(True)    
    ui.lLogFile.setText(t+".csv")
    
  else:    	      #stop log
    WriteLog=0
    ui.actionStart_writing_data_to_file.setChecked(False)
    logfile.close()
    print "Closed logfile"
    
    ui.lLogFile.setText("Not active")




###########################################################################
# Function to show graph with smaller X axis
###########################################################################
def actionDouble_Graph_Speed():
  global Graph_Speed
  
  if(Graph_Speed==1):
     Graph_Speed=2
     ui.actionDouble_Graph_Speed.setChecked(True)
  else:
     Graph_Speed=1
     ui.actionDouble_Graph_Speed.setChecked(False)



###########################################################################
# Function to show grapf with smaller Y axis 
###########################################################################
def actionBigger_Graph_Scale():
  global Graph_Scale
  
  if(Graph_Scale==1): 
     Graph_Scale=2
     ui.actionBigger_Graph_Scale.setChecked(True)
  else: 
     Graph_Scale=1
     ui.actionBigger_Graph_Scale.setChecked(False)




###########################################################################
# Function to get data from acceleration sensor
###########################################################################
def getSensorData():
  global demo
  
  if(debug==1): Show_passed_time("getSensorData start")
  
  if(demo==0):
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
    coords = [int(w) for w in f.readline().split()]
    f.close()
  else:
    coords=[0,0,0]
    coords[0]=random.uniform(-500,500)
    coords[1]=random.uniform(-20,20)
    coords[2]=random.uniform(500, 1500)
    
  if(debug==1): Show_passed_time("getSensorData end")
  
  return coords




###########################################################################
# Function to calculate and update values on screen
###########################################################################
def visualising():
  global arrOldAngles
  global arrData, arrayDataIndex, arrayDataLen, arrAccCorrection
  global logfile
  
  if(debug==1): Show_passed_time("visualising start")
  
  AccX=float(arrData[0][arrayDataIndex]) - arrAccCorrection[0]
  AccY=float(arrData[1][arrayDataIndex]) - arrAccCorrection[1]
  AccZ=float(arrData[2][arrayDataIndex]) - arrAccCorrection[2]
    
  ui.txtX.setText(str(int(AccX)))
  ui.txtY.setText(str(int(AccY)))
  ui.txtZ.setText(str(int(AccZ)))


  #Division by zero prevention
  if(AccX==0): AccX=0.1
  if(AccY==0): AccY=0.1
  if(AccZ==0): AccZ=0.1
  
  AngleA=math.atan(AccX/AccZ)*-57.3
  AngleB=math.atan(AccY/AccZ)*-57.3
  #AngleC=math.atan(AccX/AccY)*-57.3
  
  #correct negative angle
  #if(AccZ>0): AngleA=AngleA+180
  #if(AccZ>0): AngleB=AngleB+180

  #Save Angle Alpha in array for usage in graph
  arrData[3][arrayDataIndex]=AngleA
  
  ui.txtAngleA.setText(str(round(AngleA,1)))
  ui.txtAngleB.setText(str(round(AngleB,1)))
  #ui.txtAngleC.setText(str(round(AngleC,1)))

  
  #History, keep biggest angle on each direction
  if(AngleA<arrOldAngles[0][0]): 
    ui.txtAngleA_Max.setText(str(round(AngleA,1)))
    arrOldAngles[0][0]=AngleA
  if(AngleA>arrOldAngles[0][1]): 
    ui.txtAngleA_Max_2.setText(str(round(AngleA,1)))
    arrOldAngles[0][1]=AngleA    
    
  if(AngleB<arrOldAngles[1][0]): 
    ui.txtAngleB_Max.setText(str(round(AngleB,1)))
    arrOldAngles[1][0]=AngleB
  if(AngleB>arrOldAngles[1][1]): 
    ui.txtAngleB_Max_2.setText(str(round(AngleB,1)))
    arrOldAngles[1][1]=AngleB    
    
  #if(AngleC<arrOldAngles[2][0]): 
    #ui.txtAngleC_Max.setText(str(round(AngleC,1)))
    #arrOldAngles[2][0]=AngleC
  #if(AngleC>arrOldAngles[1][1]): 
    #ui.txtAngleC_Max_2.setText(str(round(AngleC,1)))
    #arrOldAngles[2][1]=AngleC    
  
  
  #Write dat into file, so it can be used in other tools
  if(WriteLog==1):
    t=strftime("%d.%b.%Y %H:%M:%S", time.localtime())
    #d=printf("%s, %d, %d, %d", t, round(degreesX,1), round(degreesY,1), round(degreesZ,1))
    #d=t + ", " + str(AccX) + ", " + str(AccY) + ", " + str(AccZ) + ", " + str(round(AngleA,3)) + ", " + str(round(AngleB,3)) + ", " + str(round(AngleC,3))
    d=t + ", " + str(AccX) + ", " + str(AccY) + ", " + str(AccZ) + ", " + str(round(AngleA,3)) + ", " + str(round(AngleB,3))
    
    if(debug==1): print d 
    
    logfile.write(d+"\n")
    
  if(debug==1): Show_passed_time("visialising end")  

  dt.update() #generate and show graph




###########################################################################
# Update graph
###########################################################################
#def graph():
  #dt.update()





###########################################################################
# Class for drawing the graph
###########################################################################
class MyCanvas(QtGui.QWidget):
  
  
###########################################################################
# Init for drawing the graph
###########################################################################
  def __init__(self, parent=None):
    QtGui.QWidget.__init__(self, ShipRolling)    
    self.setGeometry(10, 180, 781, 241)
 


###########################################################################
# This function redraws the whole graph
# call it with dt.update()
###########################################################################
  def paintEvent(self, event):
    global array, arrayDataIndex, debug
    global needed_loop_time
    global Graph_Scale, Graph_Speed
    
    if(debug==1): Show_passed_time("paintEvent start")
    
    paint = QtGui.QPainter()
    paint.begin(self)
    
    #color = QtGui.QColor(0, 0, 0)
    #color.setNamedColor("gray") #or "#ffffff"
    paint.setPen(QtGui.QColor("gray"))
    paint.setBrush(QtGui.QColor("black"))

    #show graph border
    paint.drawRect(0,0,780,240)           
    
    #Formating X axis
    #Small Y lines
    for i in range(120, 240, 10*Graph_Scale): 
      paint.drawLine(0,i,5,i) #1 line per degree
      paint.drawLine(0,240-i,5,240-i)
      paint.drawLine(775,i,780,i)
      paint.drawLine(775,240-i,780,240-i)
        
    #Big Y lines
    for i in range(120, 240, 50*Graph_Scale): 
      paint.drawLine(0,i,780,i) #line per degree
      paint.drawLine(0,240-i,780,240-i)
      paint.drawText(10, i-4, str((i-120)/10/Graph_Scale))
      paint.drawText(10, 240-i-4, str(-1*(i-120)/10/Graph_Scale))

    #Formating Y axis
    #Small X lines
    for i in range(780, 0, -40): 
      paint.drawLine(i,115,i,125)
      
    #Big X lines
    for i in range(0, 780, 240): 
      paint.drawLine(780-i,100,780-i,140)
      paint.drawText(780-i+5, 145, str(i/4/Graph_Speed))

    #Zero line
    paint.setPen(QtGui.QColor("white"))
    paint.drawLine(0,120,780,120) 

    a=arrayDataIndex #freeze current array pointer (in case reading continues)
        
    #Min/Max lines
    paint.setPen(QtGui.QColor("red"))
    i=(max(arrData[3])*-10*Graph_Scale)+120
    paint.drawLine(0,i,780,i)  
    i=(min(arrData[3])*-10*Graph_Scale)+120
    paint.drawLine(0,i,780,i)  

    #Draw graph
    paint.setPen(QtGui.QColor("yellow"))    
    
    for i in range(0,780/Graph_Speed-1):      
      k1=(a-i-1) % arrayDataLen
      k2=(k1+1) % arrayDataLen
      
      a1=int(arrData[3][k1]*-10*Graph_Scale)+120
      a2=int(arrData[3][k2]*-10*Graph_Scale)+120
      paint.drawLine(779-i*Graph_Speed, a1, 779-i*Graph_Speed+1, a2)

      #if(i==0 & debug==1): print int(arrData[3][k1]), a1
      
    paint.end()
    
    if(debug==1): Show_passed_time("paintEvent end")
    



###########################################################################
# Processes the sensor data
###########################################################################
def Process_Data():
  global arrData, arrayDataIndex, arrayDataLen
  global smoothing, needed_loop_time
    
  if(debug==1): Show_passed_time("Process_Data start")
  
  
  #Evaluate how much time expired since last run of this function
  now=time.time()
  t=1000*(now-needed_loop_time)
  print "Time since last refresh: ", str(int(t)), "ms"
  ui.txtTime.setText(str(int(t)))
  needed_loop_time = time.time()  
  
  #Get sensor data and smoothen it
  coordinations_smoothed=[0, 0, 0]
  if(debug==1): print "Sampling..."
  for i in range(smoothing):
    coordinations=getSensorData()
    if(debug==1): print coordinations
    coordinations_smoothed[0]=coordinations_smoothed[0] + coordinations[0]
    coordinations_smoothed[1]=coordinations_smoothed[1] + coordinations[1]
    coordinations_smoothed[2]=coordinations_smoothed[2] + coordinations[2]
  
  if(debug==1): print coordinations_smoothed
  
  #Write it into data array
  arrayDataIndex=arrayDataIndex+1
  arrayDataIndex=arrayDataIndex % arrayDataLen
  
  arrData[0][arrayDataIndex]=coordinations_smoothed[0]/smoothing
  arrData[1][arrayDataIndex]=coordinations_smoothed[1]/smoothing
  arrData[2][arrayDataIndex]=coordinations_smoothed[2]/smoothing

  if(debug==1): Show_passed_time("Process_Data end")

  #update values on screen
  visualising()
  
  
  
###########################################################################
# Main function
###########################################################################
passed_time = time.time()  #Start time
needed_loop_time=passed_time

try:
  if(sys.argv[1]=="debug"):
    debug=1
except:
  debug=0

#if not on the N900, a acceleration sensor has to be simulated
uname=os.uname()
if(uname[1]=="Nokia-N900"):
  demo=0	#runs on real N900 hardware
else:
  demo=1	#runs on other hardware/OS
 

#if not on the N900, use another place for the log file 
if(demo==1): logfolder="/tmp/" #folder on devel PC

#Create the arrays
arrData=[[0]*arrayDataLen,[0]*arrayDataLen,[0]*arrayDataLen,[0]*arrayDataLen] #main data
arrayDataIndex=0	#points to latest data field
 
arrOldAngles=[[0]*3,[0]*3,[0]*3] #max angles
arrAccCorrection=[0,0,0] #sensor corrections

WriteLog=0
Graph_Speed=1
Graph_Scale=1
Use_own_Calibration=0

#Main screen
app = QtGui.QApplication(sys.argv)
ShipRolling = QtGui.QMainWindow()
ui = Ui_ShipRolling()
ui.setupUi(ShipRolling)

#info screen
Info = QtGui.QDialog()
ui1 = Ui_Info()
ui1.setupUi(Info)



if(debug==1): Show_passed_time("Start")


# constant timer
app.timer_sampling = QtCore.QTimer()
QtCore.QObject.connect(app.timer_sampling, QtCore.SIGNAL("timeout()"), Process_Data)

#app.timer_visualising = QtCore.QTimer()
#QtCore.QObject.connect(app.timer_visualising, QtCore.SIGNAL("timeout()"), visualising)

#app.timer_graph = QtCore.QTimer()
#QtCore.QObject.connect(app.timer_graph, QtCore.SIGNAL("timeout()"), graph)



ShipRolling.show()

dt = MyCanvas()
dt.show()

app.timer_sampling.start(250)
#app.timer_visualising.start(100)
#app.timer_graph.start(400)

#Buttons
#QtCore.QObject.connect(ui.bCalibrate, QtCore.SIGNAL("clicked()"), SetAccCorrection)
#QtCore.QObject.connect(ui.bReset, QtCore.SIGNAL("clicked()"), ResetMaxAngles)
#QtCore.QObject.connect(ui.bWriteLog, QtCore.SIGNAL("clicked()"), StartStopLog)

#Menu actions
ShipRolling.connect(ui.actionCalibrate_Sensor, QtCore.SIGNAL("triggered()"), actionSetAccCorrection)
ShipRolling.connect(ui.actionReset_max_Angle, QtCore.SIGNAL("triggered()"), actionResetMaxAngles)
ShipRolling.connect(ui.actionStart_writing_data_to_file, QtCore.SIGNAL("triggered()"), actionStartStopLog)
ShipRolling.connect(ui.actionReset_Graph, QtCore.SIGNAL("triggered()"), actionResetGraph)
ShipRolling.connect(ui.actionDouble_Graph_Speed, QtCore.SIGNAL("triggered()"), actionDouble_Graph_Speed)
ShipRolling.connect(ui.actionBigger_Graph_Scale, QtCore.SIGNAL("triggered()"), actionBigger_Graph_Scale)
ShipRolling.connect(ui.actionInfo, QtCore.SIGNAL("triggered()"), actionInfo)


# Now we can start it.
sys.exit(app.exec_())
