#include <game.h>

View* Game::view=NULL;

Game::Game():QWidget(0)
{
	sheepPix.load("/home/opt/sheep/images/shp.png");
	fencePix.load("/home/opt/sheep/images/fence.png");
	fenceClosedPix.load("/home/opt/sheep/images/fenceC.png");
	grassPix.load("/home/opt/sheep/images/grass.png");
	dogPix.load("/home/opt/sheep/images/dog.png");
	iconExitPix.load("/home/opt/sheep/images/sheep_exit.png");
	iconSoundOnPix.load("/home/opt/sheep/images/sheep_sound-on.png");
	iconSoundOffPix.load("/home/opt/sheep/images/sheep_sound-off.png");
	iconPlayPix.load("/home/opt/sheep/images/sheep_play.png");
	iconPausePix.load("/home/opt/sheep/images/sheep_pause.png");
	
	acc=AccSensor::New();
	
// 	levelZeroX = acc->getRotationDeg()+90;
	levelZeroX=acc->getX();
	levelZeroY = ((int)acc->getPitchDeg()+360)%360;

	lastX=acc->getX();
	lastY=acc->getY();
	lastZ=acc->getZ();
	
	connectToDbusVibra();
	

	soundEngine=new SoundEngine();

	sound = 1;

	pauseOn=0;
	

	sheepToHerd=3;
	won=0;

	backgroundPlaying=0;

	startBackground();
	
}

void Game::startBackground()
{

	if (!backgroundPlaying)
	{
		std::cout<<"starting background playback"<<std::endl;
		backgroundThread;
		pthread_create(&backgroundThread,NULL,&SoundEngine::playBackground,NULL);
		backgroundPlaying=1;
	}

}

void Game::stopBackground()
{
	if (backgroundPlaying)
	{
		std::cout<<"stopping background playback"<<std::endl;
		soundEngine->background->pause();
		backgroundPlaying=0;


	}
	

}

void Game::caught()
{

	--sheepToHerd;
	if (sheepToHerd==0)
		win();
}


void Game::win()
{
	
	pauseOn=1;
	won=1;
	view->clock->setPos(220,80);
	view->win();

	
}


void Game::connectToDbusVibra()
{

	dbus_error_init(&errVib);
	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}

	
	if (NULL == connVib)
	{
		return;
	}

	retVib = dbus_bus_request_name(connVib, "sheep.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);

	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}

	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
	{
		return;
	}
	connectedVib=1;
}

void Game::vibrate(int type)
{

        if (type==0) //change this to enum
        {
                paramVib = "PatternTouchscreen";
        }

        else if (type==1)
        {
                paramVib = "PatternPowerKeyPress";
        }

        else if (type==2)
        {
                paramVib= "PatternChatAndEmail";
        }

        if (connectedVib==0)
        {
                connectToDbusVibra();
                if (connectedVib==0)
                        return;
        }

        msgVib = dbus_message_new_method_call("com.nokia.mce",
                        "/com/nokia/mce/request",
                        "com.nokia.mce.request",
                        "req_vibrator_pattern_activate");



        if (NULL == msgVib)
        {
                return;
        }

        dbus_message_iter_init_append(msgVib, &argsVib);

        if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
        {
                return;
        }

        if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
        {
                return;
        }

        if (NULL == pendingVib)
        {
                return;
        }

        dbus_connection_flush(connVib);
        dbus_message_unref(msgVib);

}

