#include "poi.h"
#include <iostream>
#include <baseobj.h>

Game* Poi::game=NULL;


Poi::Poi(qreal x_, qreal y_, qreal value_, qreal attraction_, int type_): QGraphicsItem(0), x(x_), y(y_), value(value_), type(type_), attraction(attraction_)
{
	objType=0;
	setZValue(poiDepth);
	colVec=new Vec(0,0);


}

void Poi::paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget)
{

//	painter->drawEllipse(boundingRect());
//	painter->drawRect(boundingRect());


	
	if (type==1)
	{
		
		
		QRectF source = QRectF(0,0,game->grassPix.width(),game->grassPix.height());	
	//	painter->scale(value/86.0,value/86.0);
		painter->setOpacity(value/100.0);
		painter->drawPixmap(source,game->grassPix,source);
	}
	else if (type==0)
	{

		QRectF source = QRectF(0,0,game->dogPix.width(),game->dogPix.height());	
		painter->drawPixmap(source,game->dogPix,source);
	//	painter->drawEllipse(boundingRect());

	}

		
}

QRectF Poi::boundingRect() const
{
	return QRectF(0,0,value,value);
}

void Poi::advance(int step)
{


	if (step==1 || value==0 || game->pauseOn)
		return;



	
	if (type==1)
	{
	
	
		--value;
		attraction=value;
		if (value==0)
		{
			scene()->removeItem(this);
			emit deleteMe(this);
			return;
		}
	}
	else if (type==0)
	{

	
	
		int noCollision=1;
		
		colVec->clear();
		

		
		for (int i=0;i<scene()->collidingItems(this).count();++i)
		{
			if (((Poi*)(scene()->collidingItems(this)[i]))->objType==1)//sheep
			{

				colVec->add(((Sheep*)(scene()->collidingItems(this)[i]))->x+game->sheepPix.width()/2-x-value/2,((Sheep*)(scene()->collidingItems(this)[i]))->y+game->sheepPix.height()/2-y-value/2);
				noCollision=0;
				continue;	 

			}
					
			qreal distanceFence = sqrt(pow(x+value/2-((Fence*)(scene()->collidingItems(this)[i]))->x-game->fencePix.width()/2,2)+pow(y+value/2-((Fence*)(scene()->collidingItems(this)[i]))->y-game->fencePix.height()/2,2));
	

		//	if (distanceFence<50)
					
		
			if (((Poi*)(scene()->collidingItems(this)[i]))->objType==2 && distanceFence>=50)//fence
			{
				colVec->add(((Fence*)(scene()->collidingItems(this)[i]))->x+game->fencePix.width()/2-x-value/2,((Fence*)(scene()->collidingItems(this)[i]))->y+game->fencePix.height()/2-y-value/2);
				noCollision=0;

			}

			else if (((Poi*)(scene()->collidingItems(this)[i]))->objType==2 && distanceFence<50)
			{
				((Fence*)(scene()->collidingItems(this)[i]))->dogIn=1;
				qreal XX=((Fence*)(scene()->collidingItems(this)[i]))->x+game->fencePix.width()/2-x-value/2;
				qreal YY=((Fence*)(scene()->collidingItems(this)[i]))->y+game->fencePix.height()/2-y-value/2;
				colVec->add(-XX,-YY);
				noCollision=0;
												

			}

				
		}

	
	//	int rot = game->acc->getRotationDeg()+90;
	        int pitch = ((int)game->acc->getPitchDeg()+360)%360;

		int rot = game->acc->getX();
	  //      int pitch = game->acc->getZ();
		
		qreal tiltRot=-1*(rot-game->levelZeroX)/180.0;
		qreal tiltPitch=1*(pitch-game->levelZeroY)/30.0;
			
		
		x+=tiltRot*6*noCollision-colVec->x/10;
		if (x>760)
	     		x=760;
			        
		if (x<0)
			x=0;

				        
		y+=tiltPitch*6*noCollision-colVec->y/10;
		if (y>440)
			y=440;
		if (y<0)
			y=0;
							


	}
	setPos(x,y);

}
