#include <icon.h>


osso_context_t* Icon::_osso = osso_initialize("com.warda.noscreenblank", "ONE", TRUE, NULL);
Game* Icon::game=NULL;

Icon::Icon(int type_):type(type_)
{
	setZValue(iconDepth);
	objType=3;
	inMove=0;
	active=1;

}

void Icon::paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget)
{
	if (!inMove)
		painter->setOpacity(0.8);
	else 
	{
		painter->setOpacity(0.5);
		painter->setPen(Qt::green);
		painter->setBrush(Qt::green);
		painter->drawRect(-x,-y,800,50);
		painter->setPen(Qt::red);
		painter->setBrush(Qt::red);
		painter->drawRect(-x,480-y-50,800,50);
		painter->setOpacity(0.9);
	}

	if (active)
	{
		if (type==0)
			painter->drawPixmap(0,0,game->iconExitPix);
		else if (type==1)
			painter->drawPixmap(0,0,game->iconSoundOnPix);
		else if (type==2)
			painter->drawPixmap(0,0,game->iconPlayPix);
			
	}
	else
	{
		if (type==0)
			painter->drawPixmap(0,0,game->iconExitPix);
		else if (type==1)
			painter->drawPixmap(0,0,game->iconSoundOffPix);
		else if (type==2)
			painter->drawPixmap(0,0,game->iconPausePix);

	}
		
	
//	painter->drawEllipse(boundingRect());
}


QRectF Icon::boundingRect() const
{
	        return QRectF(0,0,60,60);
}

void Icon::advance(int step)
{
	if (step==1)
		return;

	osso_display_state_on(_osso);
        osso_display_blanking_pause(_osso);
	


	
	if (inMove==0 && y > -30 && active==1)
		y-=40;
	if (inMove==0 && y < 420 && active==0)
		y+=40;
	
	if (x<0) x=0;
	if (x>740) x=740;
	if (y<0) y=0;
	if (y>430) y=430;

	if (y>380) //deactivate
	{
		if (type==0) //exit
			game->app->quit();

		if (type==1)
		{
			game->sound=0;
			game->stopBackground();
		}
		if (type==2)
			game->pauseOn=1;

	}

	if (y<200) //activeate
	{
		if (type==1)
		{
			game->sound=1;
			game->startBackground();
		}
		if (type==2 && game->won==0)
			game->pauseOn=0;


	}	


	
	setPos(x,y);

}



void Icon::move(qreal x_, qreal y_)
{
	x=x_;
	y=y_;
//	if (x<0) x=0;
//	if (x>740) x=740;
//	if (y<-30) y=-30;
//	if (y>420) y=420;

	if (y<240) active=1;
	else active=0;
	

}


