#include <glib.h>
#include <glib/gprintf.h>
#include <osso-log.h>
#include <string.h>
#include <stdlib.h>
#include <curl/curl.h>

#include <sharing-http.h>
#include <sharing-plugin-interface.h>
#include <sharing-entry.h>
#include <sharing-tag.h>

#include "twitpic_post.h"

#define END_POINT "http://twitpic.com/api/uploadAndPost"

#if 0
size_t my_write_func(void *ptr, size_t size, size_t nmemb, GString *data)
{
      return fwrite(ptr, size, nmemb, stream);
}
#endif

size_t twitpic_write_func(void *ptr, size_t size, size_t nmemb, void *user_data)
{
    GString *data = (GString *)user_data;
    ULOG_DEBUG_L ("WRITE FUNC:  %p[%d][%d]", data, size, nmemb);

    g_string_append_len(data, (char*)ptr, size * nmemb);

    return size*nmemb;
}

int twitpic_progress_func(GtkWidget *bar,
                     double t, /* dltotal */ 
                     double d, /* dlnow */ 
                     double ultotal,
                     double ulnow)
{
  ULOG_DEBUG_L ("Progress %d / %d (%g %%)\n", d, t, d*100.0/t);
  return 0;
}

int
twitpic_upload_media(const char *username,
                     const char *password,
                     SharingEntryMedia *media)
{
  GString *response;
  CURL* hCurl = NULL;
  CURLcode hResult;
  char curl_errorstr[CURL_ERROR_SIZE];


  struct curl_httppost *post = NULL;
  struct curl_httppost *last = NULL;

  hCurl = curl_easy_init();

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "username",
                             CURLFORM_COPYCONTENTS, username,
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "password",
                             CURLFORM_COPYCONTENTS, password,
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "message",
                             CURLFORM_COPYCONTENTS, sharing_entry_media_get_desc(media),
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "media",
                             CURLFORM_FILE, sharing_entry_media_get_localpath(media),
                             CURLFORM_END);

  hResult = curl_easy_setopt(hCurl, CURLOPT_URL, END_POINT);
  hResult = curl_easy_setopt(hCurl, CURLOPT_HTTPPOST, post);
  hResult = curl_easy_setopt(hCurl, CURLOPT_ERRORBUFFER, curl_errorstr);

  response = g_string_new("");
  ULOG_DEBUG_L("response created at: %p", response);

  hResult = curl_easy_setopt(hCurl, CURLOPT_WRITEDATA, response);
//  hResult = curl_easy_setopt(hCurl, CURLOPT_READFUNCTION, twitpic_read_func);
  hResult = curl_easy_setopt(hCurl, CURLOPT_WRITEFUNCTION, twitpic_write_func);
//  hResult = curl_easy_setopt(hCurl, CURLOPT_PROGRESSFUNCTION, twitpic_progress_func);

  hResult = curl_easy_perform(hCurl);

  int ret = SHARING_SEND_SUCCESS;

  if (hResult != CURLE_OK) {
    ULOG_DEBUG_L ("SEND ERROR: %s, media: %s, username: %s, password: %s", curl_errorstr, sharing_entry_media_get_localpath(media), username, password);
    return -1;
  } else {
    ULOG_DEBUG_L ("SEND RESPONSE: %s", response->str);
    if (g_strstr(response->str, "<rsp stat=\"ok\">") == 0) {
      ULOG_DEBUG_L ("API ERROR: %s", response->str);
      if (g_strstr(response->str, "<err code=\"1001\"") != 0) {
        ULOG_DEBUG_L ("API ERROR FIX: 1001");
        ret = SHARING_SEND_ERROR_AUTH;
      } else if (g_strstr(response->str, "<err code=\"1002\"") != 0) {
        ULOG_DEBUG_L ("API ERROR FIX: 1002");
        ret = SHARING_SEND_ERROR_FILE_FORMAT;
      } else if (g_strstr(response->str, "<err code=\"1003\"") != 0) {
        ULOG_DEBUG_L ("API ERROR FIX: 1003");
        ret = SHARING_SEND_ERROR_FILE_FORMAT;
      } else if (g_strstr(response->str, "<err code=\"1004\"") != 0) {
        ULOG_DEBUG_L ("API ERROR FIX: 1004");
        ret = SHARING_SEND_ERROR_UPLOAD_LIMIT;
      }
    }
  }

  curl_formfree(post);
  curl_easy_cleanup(hCurl);

  g_string_free(response, TRUE);

  sharing_entry_media_set_sent(media, TRUE);
  return ret;
}

SharingPluginInterfaceAccountValidateResult
twitpic_post_validate_account (SharingAccount *account,
                               ConIcConnection *con,
                               gboolean *cont,
                               gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "twitpic_post_validate_account()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);

  return SHARING_ACCOUNT_VALIDATE_SUCCESS;
}


SharingPluginInterfaceSendResult 
twitpic_post_upload_to_service (SharingTransfer *transfer,
                               ConIcConnection *con,
                               gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "twitpic_post_upload_to_service()";
#endif
  GSList *m = NULL;
  int result = SHARING_SEND_SUCCESS;

  ULOG_DEBUG_L ("Entered %s",fn);

  SharingEntry* entry = sharing_transfer_get_entry(transfer);
  SharingAccount* account = sharing_entry_get_account(entry);

  curl_global_init(CURL_GLOBAL_ALL);

  for(m = sharing_entry_get_media(entry); m != NULL; m = g_slist_next(m)) {
      result = twitpic_upload_media(sharing_account_get_username(account),
                                    sharing_account_get_password(account),
                                    m->data);
      if (result != 0) {
          break;
      }
  }

  curl_global_cleanup();
  return result;
}

