/**
    File: picasa_post.h
    
    Author: Tero Niemel

*/

#ifndef _PICASA_POST_H_
#define _PICASA_POST_H_

/**
 * PICASA_POST_BUF_LIMIT_C:
 *
 * Size limit for HTTP request response buffer.
*/
#define PICASA_POST_BUF_LIMIT_C 2*1024 /* 2Kb should be enough */
/**
 * HTTP_RES_CODE_OFFSET_C:
 *
 * HTTP response code offset from beginning of response.
*/
#define HTTP_RES_CODE_OFFSET_C 9
/**
 * HTTP_RES_ERR_OFFSET_C:
 *
 * Picasa error response offset.
*/
#define HTTP_RES_ERR_OFFSET_C 6
/**
 * LOGIN_URL_C:
 *
 * Login URL for the Google services.
*/
#define LOGIN_URL_C "https://www.google.com/accounts/ClientLogin"
/**
 * FEED_URL_C:
 *
 * Feed URL prefix for uploading media.
*/
#define FEED_URL_C "http://picasaweb.google.com/data/feed/api/user/default"
/**
 * SERVICE_C:
 *
 * Service information in Login for Picasaweb service. 
*/
#define SERVICE_C "lh2"
/**
 * MAPS_URL_C:
 *
 * Google maps URL for getting geocoding.
*/
#define MAPS_URL_C "http://maps.google.com/maps/geo?"


/**
 * picasa_response_codes_t:
 *
 * Internal response codes for uploads.
*/
typedef enum {
  HTTP_OK = 200,
  HTTP_CREATED = 201,
  HTTP_BAD_REQ = 400,
  HTTP_FAILED = 403,
  HTTP_NOT_FOUND = 404,
  HTTP_UNSUPPORTED_MEDIA = 415,
  HTTP_SERVICE_DOWN = 503,
  CONNECTION_DISCONNECTED = 701,
  CANCELLED_BY_USER = 702,
  NETWORK_SEND_FAILED = 703,
  GENERAL_ERROR = 704
} picasa_response_codes_t;

/**
 * PICASA_POST_ERROR_BAD_AUTHENTICATION_C:
 * 
 * Error string for bad authentication.
*/
#define PICASA_POST_BAD_AUTHENTICATION_C "BadAuthentication"
/**
 * PICASA_POST_FILE_TOO_BIG_C:
 * 
 * Error string for too big images.
*/
#define PICASA_POST_FILE_TOO_LARGE_C "Image too large."
/**
 * PICASA_POST_NOT_AN_IMAGE_C:
 *
 * Error string for unsupport file formats.
*/
#define PICASA_POST_NOT_AN_IMAGE_C "Not an image."




SharingPluginInterfaceAccountValidateResult
picasa_post_validate_account( SharingAccount *account,
			      ConIcConnection *con,
			      gboolean *cont,
			      gboolean *dead_mans_switch );

SharingPluginInterfaceSendResult 
picasa_post_upload_to_service( SharingTransfer *transfer,
			       ConIcConnection *con,
			       gboolean *dead_mans_switch );


#endif /* _PICASA_POST_H_ */
