/**
    File: picasa_plugin.c
    
    Author: Tero Niemel

*/

#include <gtk/gtk.h>
#include <glib.h>
#include <osso-log.h>
#include <sharing-plugin-interface.h>

#include "picasa_post.h"


guint 
sharing_plugin_interface_init (gboolean *dead_mans_switch);

guint 
sharing_plugin_interface_uninit (gboolean *dead_mans_switch);

SharingPluginInterfaceSendResult 
sharing_plugin_interface_send(SharingTransfer *transfer,
			      ConIcConnection *con,
			      gboolean *dead_mans_switch);

SharingPluginInterfaceAccountSetupResult 
sharing_plugin_interface_account_setup (GtkWindow* parent, 
					SharingService* service, 
					SharingAccount** worked_on, 
					osso_context_t* osso);

SharingPluginInterfaceAccountValidateResult 
sharing_plugin_interface_account_validate (SharingAccount* account,
					   ConIcConnection *con,
					   gboolean *cont,
					   gboolean *dead_mans_switch);

SharingPluginInterfaceEditAccountResult 
sharing_plugin_interface_edit_account (GtkWindow *parent, 
				       SharingAccount* account,
				       ConIcConnection *con,
				       gboolean *dead_mans_switch);



/**
 * sharing_plugin_interface_init:
 * @dead_mans_swtich: -
 *
 * Initialize plugin.
*/
guint 
sharing_plugin_interface_init (gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_init()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: Initializing plugin",fn); 

  *dead_mans_switch = FALSE;

  return 0;
}

/**
 * sharing_plugin_interface_uninit:
 * @dead_mans_swtich: -
 *
 * Uninitialize plugin.
*/
guint 
sharing_plugin_interface_uninit (gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_uninit()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: Uninitializing plugin",fn);

  *dead_mans_switch = FALSE;

  
  return 0;
}

/**
 * sharing_plugin_interface_send:
 * @transfer: Sharing transfer information
 * @con: Conic connection
 * @dead_mans_switch: -
 *
 * Send files to service.
*/
SharingPluginInterfaceSendResult 
sharing_plugin_interface_send (SharingTransfer *transfer,
			       ConIcConnection *con,
			       gboolean *dead_mans_switch) {
#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_send()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);

  SharingPluginInterfaceSendResult retval =
    SHARING_SEND_CANCELLED;
  
  /* param check */
  if (transfer == NULL) {
    ULOG_ERR_L ("%s: NULL parameter",fn);
    return retval;
  }

  *dead_mans_switch = FALSE;

  retval = picasa_post_upload_to_service (transfer, con,
					  dead_mans_switch);

  ULOG_DEBUG_L ("%s: Returning with %d",fn,retval);

  return retval;
}

/**
 * sharing_plugin_interface_account_setup:
 * @parent: Parent window
 * @service: Sharing service information
 * @worked_on: Account to use
 * @osso: Osso context for dbus usage
 *
 * For creating own account setup dialog.
*/
SharingPluginInterfaceAccountSetupResult 
sharing_plugin_interface_account_setup (GtkWindow* parent, 
					SharingService* service, 
					SharingAccount** worked_on, 
					osso_context_t* osso) {
#ifdef DEBUG  
  gchar *fn = "sharing_plugin_interface_account_setup()";
#endif

  SharingPluginInterfaceAccountSetupResult retval = 
    SHARING_ACCOUNT_SETUP_SUCCESS;

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: SharingAccount = %0X",fn, (guint)*worked_on);
  ULOG_DEBUG_L ("%s: Sharing service = %s",fn,sharing_service_get_name(service));

  ULOG_DEBUG_L ("%s: Returning with %d",fn,retval);

  return retval;
}

/**
 * sharing_plugin_interface_account_validate:
 * @account: Account to validate
 * @con: Conic connection to use
 * @cont: Continue flag is user cancels dialog
 * @dead_mans_switch: -
 *
 * Validate user added account.
*/
SharingPluginInterfaceAccountValidateResult 
sharing_plugin_interface_account_validate (SharingAccount* account,
					   ConIcConnection *con,
					   gboolean *cont,
					   gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_account_validate()";
#endif

  SharingPluginInterfaceAccountValidateResult retval =
    SHARING_ACCOUNT_VALIDATE_NOT_STARTED;

  ULOG_DEBUG_L ("Entered %s",fn);
  
  /* param check */
  if (!con || !account) {
    ULOG_ERR_L ("%s: NULL parameter",fn);
    return retval;
  }

  gchar *uname = sharing_account_get_username (account);
  ULOG_DEBUG_L ("%s: account = %s",fn,uname);
 
  /* problem gettin account information */
  if (!uname) {
    return SHARING_ACCOUNT_VALIDATE_ACCOUNT_NOT_FOUND;
  }

  retval = picasa_post_validate_account (account, con, cont, dead_mans_switch);

  ULOG_DEBUG_L ("%s: Returning with %d",fn,retval);

  return retval;
}



/**
 * sharing_plugin_interface_edit_account:
 * @parent: Parent window
 * @account: Account to edit
 * @con: Conic connection
 * @dead_mans_switch: -
 *
 * For creating editing account dialog.
*/
SharingPluginInterfaceEditAccountResult 
sharing_plugin_interface_edit_account (GtkWindow *parent, 
				       SharingAccount* account,
				       ConIcConnection *con,
				       gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_edit_account()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);

  SharingPluginInterfaceEditAccountResult retval =
    SHARING_EDIT_ACCOUNT_SUCCESS;
  
  return retval;
}



