/*
 * This file is part of sharing-plugin-template
 *
 */

#include "send.h"
#include "libmsa_interface.h"
#include "plugin.h"


/**
 * send:
 * @account: #SharingTransfer to be send
 * @con: Connection used
 * @dead_mans_switch: Turn to %FALSE at least every 30 seconds.
 *
 * Sends #SharingTransfer to service.
 *
 * Returns: #SharingPluginInterfaceSendResult
 */
SharingPluginInterfaceSendResult vkontakte_send (SharingTransfer* transfer,
    ConIcConnection* con, gboolean* dead_mans_switch)
{
    SharingEntry *entry = sharing_transfer_get_entry(transfer);
    SharingAccount* account = sharing_entry_get_account(entry);
    SharingEntryMedia* media = NULL;

    /** get selected album **/
    const gchar* album =  sharing_entry_get_option (entry, "album");

    gchar* account_name = sharing_account_get_param (account, "username");

    msa_print("%s:%d:%s: account=%s, album=%s\n", __FILE__, __LINE__, __FUNCTION__, account_name, album);

    if(!libvk_init(con, account_name)){
        return SHARING_SEND_ERROR_UNKNOWN;
    }

    /* authorize */
    gchar* params = sharing_account_get_param (account, NODE_SETTINGS);
    libvk_set_settings(params);
    g_free(params);

    //libvk_getHash();

    /* get enterie media */
    const gchar* path_to_photo, *desc;
    gchar* file_name;

    for (GSList* sharing_element = sharing_entry_get_media (entry); sharing_element != NULL;
            sharing_element = g_slist_next(sharing_element)) {
        media = sharing_element->data;

	if (!sharing_entry_media_get_sent(media))
	{
    	    /* send photo */
    	    path_to_photo = sharing_entry_media_get_localpath(media);
    	    file_name = sharing_entry_media_get_filename(media);
    	    desc = sharing_entry_media_get_desc(media);
    	    msa_print("%s:%d:%s: upload image: %s\n", __FILE__, __LINE__, __FUNCTION__, file_name);
    	    if (FALSE == libvk_uploadPhoto(account, (gchar*)album, "Default Album", (gchar*)path_to_photo, file_name, desc)) {
        	msa_print("%s:%d:%s: error upload photo\n", __FILE__, __LINE__, __FUNCTION__);
        	g_free(file_name);
        	libvk_uninit();
        	return SHARING_SEND_ERROR_UNKNOWN;
    	    } else {
        	/* If success mark media as sent */
        	sharing_entry_media_set_sent (media, TRUE);
    	    }
    	    g_free(file_name);
        }
    }

    msa_print("%s:%d:%s: finish upload photo\n", __FILE__, __LINE__, __FUNCTION__);
    libvk_uninit ();

    return SHARING_SEND_SUCCESS;
}





