/* 
 * File:   libmsa_interface.h
 * Author: Ilya Burlak
 *
 * Created on 23.08.2010, 15:33
 */

#ifndef _LIBMSA_INTERFACE_H_
#define _LIBMSA_INTERFACE_H_

#include <glib.h>
#include <sharing-plugin-interface.h>
#include <sharing-service-option.h>
#include <dlfcn.h>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xmlstring.h>

#include <stdio.h>
#include <mysocials_driver.h>
#include <osso-log.h>

#ifdef MSAVK
#include "msavk.h"
#endif

#ifdef MSAMM
#include "msamm.h"
#endif

#ifdef MSAPB
#include "msapb.h"
#endif


#define XPATH_GET_ALBUM "//Response/Params/array[@name='albumList']"
#define XPATH_GET_PARAMS "//Response/Params"
#define ALBUM_PROP_ID "id"
#define XPATH_GET_FUNCTION "//Response/@function"
#define XPATH_GET_AUTH_STATUS "//Response/@authorized"
#define XPATH_GET_ERRCODE "//Response[@class='systemMessages']/Params/string[@name='code']"

#define NODE_SETTINGS "settings"

#ifdef DEBUG
#define msa_print(...) g_print(__VA_ARGS__)
#define msa_debug(...) g_print(__VA_ARGS__)
#else
#define msa_print(...)
#define msa_debug(...)
#endif

void* handle;
struct msa_module* driver_module;
gint (* driver_init)(struct msa_module*);

gboolean libvk_init(ConIcConnection *conn, gchar* account_name);

void libvk_uninit();

void libvk_set_settings(gchar *params);

gboolean libvk_get_settings(SharingAccount* account);

SharingPluginInterfaceSendResult libvk_getAlbums(SharingAccount* account, GSList** list_album);

gboolean libvk_uploadPhoto(SharingAccount* account, const gchar *aid, const gchar *aname, const gchar *file, const gchar *file_name, const gchar *desc);

xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc);

xmlXPathObject* xpath(gchar* req, xmlDocPtr doc);

gboolean libvk_testConnection(SharingAccount* account);

#endif
