/* 
 * File:   edit_ui.c
 * Author: burlak
 *
 * Created on October 13, 2010, 12:24 PM
 */

#include "ui.h"

SharingPluginInterfaceAccountSetupResult
    use_existing_acc(GtkWidget* dialog,
                     SharingAccount* account);

/**
 * Create ui for creates new account
 * @param parent
 * @param worked_on
 * @param isEdit - if account creating then false, else true
 * @return result
 */
SharingPluginInterfaceAccountSetupResult
create_ui (GtkWindow* parent,
           SharingAccount* account,
           gboolean isEdit)
{
    GtkWidget *dlg = 0;

    ULOG_INFO_L("Starting Mobilblogg UI");


    if (isEdit) {
        dlg = gtk_dialog_new_with_buttons ("Edit account - Vkontakte", parent,
				                           GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				                           "Reconnect", 15,
                                                           "Delete account", 17,
                                           NULL);
    } else {
        dlg = gtk_dialog_new_with_buttons ("Account setup - Vkontakte", parent,
				                           GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				                           "Use existing", 15,
//                                                           "Register new", 16,
                                           NULL);
    }

    GtkWidget *dlg_content = gtk_dialog_get_content_area (GTK_DIALOG (dlg));
    GtkWidget* label1 = gtk_label_new("Use existing - use an existing vkontakte account");
//    GtkWidget* label2 = gtk_label_new("Register new - register new vkontakte account ");
    GtkWidget* vbox = gtk_vbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox), label1, FALSE, FALSE, 0);
//    gtk_box_pack_start(GTK_BOX(vbox), label2, FALSE, FALSE, 0);

    /* User Name */
    GtkWidget *label3 = gtk_label_new ("Account name - this field is required.");
    GtkWidget* username = hildon_entry_new (HILDON_SIZE_AUTO);
    if (isEdit)
        gtk_entry_set_text(GTK_ENTRY(username), sharing_account_get_username (account));
    hildon_entry_set_placeholder (HILDON_ENTRY (username), (gchar*)"User name");

    gtk_box_pack_start(GTK_BOX(vbox), label3, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), username, FALSE, FALSE, 0);
    gtk_container_add(GTK_CONTAINER (dlg_content), vbox);
    gtk_widget_show_all (GTK_WIDGET (dlg));

    gint result = gtk_dialog_run (GTK_DIALOG (dlg));

    if (result == 15) {
        sharing_account_set_username (account, gtk_entry_get_text (GTK_ENTRY (username)));
        sharing_account_set_param(account, NODE_SETTINGS, NULL);
        gtk_widget_destroy (dlg);
        return SHARING_EDIT_ACCOUNT_SUCCESS;
//    } else if (result == 16){
//        gtk_widget_destroy (dlg);
//        return SHARING_EDIT_ACCOUNT_SUCCESS;
    } else if (result == 17){
        gtk_widget_destroy (dlg);
        return SHARING_EDIT_ACCOUNT_DELETE;
    } else {
        gtk_widget_destroy (dlg);
        return SHARING_EDIT_ACCOUNT_CANCELLED;
    }
}



