/*
 * This file is part of sharing-plugin-template
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include "plugin.h"
#include "libvkontakte_interface.h"
#include "ui.h"

/**
 * sharing_plugin_interface_init:
 * @dead_mans_switch: What?
 *
 * Initialize interface
 *
 * Returns: 0
 */
guint sharing_plugin_interface_init (gboolean* dead_mans_switch)
{
    msa_print("%s:%d:%s: plugin initialization\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L("sharing_manager_plugin_interface_init");
    return 0;
}

/**
 * sharing_plugin_interface_uninit:
 * @dead_mans_switch: What?
 *
 * Uninitialize interface
 *
 * Returns: 0
 */
guint sharing_plugin_interface_uninit (gboolean* dead_mans_switch)
{
    msa_print("%s:%d:%s: plugin shutdown\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L("sharing_manager_plugin_interface_uninit");
    return 0;
}

/**
 * sharing_plugin_interface_send:
 * @transfer: Transfer to be send
 * @con: Connection used
 * @dead_mans_switch: 
 *
 * Send interface.
 *
 * Returns: Result of send
 */
SharingPluginInterfaceSendResult sharing_plugin_interface_send
    (SharingTransfer* transfer, ConIcConnection* con,
    gboolean* dead_mans_switch)
{
    msa_print("%s:%d:%s: sharing_plugin_interface_send: START\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L ("sharing_plugin_interface_send");
    SharingPluginInterfaceSendResult ret_val = SHARING_SEND_ERROR_UNKNOWN;
    ret_val = vkontakte_send(transfer, con, dead_mans_switch);
    return ret_val;
}

/**
 * sharing_plugin_interface_account_setup:
 * @transfer: #SharingTransfer send
 * @service: #SharingService
 * @worked_on: Connection used
 * @osso_context_t: Osso context
 *
 * Send interface
 *
 * Returns: Result of account setup
 */
SharingPluginInterfaceAccountSetupResult sharing_plugin_interface_account_setup
    (GtkWindow* parent, SharingService* service, SharingAccount** worked_on,
    osso_context_t* osso)
{
    msa_print ("%s:%d:%s: sharing_plugin_interface_account_setup vkontakte\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L ("sharing_plugin_interface_account_setup vkontakte");

    if (!worked_on || !*worked_on)
         return SHARING_ACCOUNT_SETUP_ERROR_UNKNOWN;

    SharingPluginInterfaceEditAccountResult res = create_ui(parent, *worked_on, FALSE);

    if (res == SHARING_EDIT_ACCOUNT_SUCCESS)
         return SHARING_ACCOUNT_SETUP_SUCCESS;
    else
	return SHARING_ACCOUNT_SETUP_ERROR_UNKNOWN;
}

/**
 * sharing_manager_plugin_interface_account_validate:
 * @account: Account tested
 * @con: Connection used to test account
 * @dead_mans_switch: 
 *
 * Validates account information.
 *
 * Returns: Result of account validation
 */
SharingPluginInterfaceAccountValidateResult
sharing_plugin_interface_account_validate (SharingAccount* account, 
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch)
{
    msa_print ("%s:%d:%s: sharing_plugin_interface_account_validate\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L ("sharing_plugin_interface_account_validate");
    
    SharingPluginInterfaceAccountValidateResult ret_val = validate (account, con, cont, dead_mans_switch);
    
    msa_print("%s:%d:%s: validate result=%d\n", __FILE__, __LINE__, __FUNCTION__, ret_val);
    
    return ret_val;
}

/**
 * sharing_plugin_interface_edit_account:
 * @account: Account tested
 * @con: Connection used to test account
 * @dead_mans_switch: 
 *
 * Edit account plugin implementation.
 *
 * Returns: Result of account edit
 */
SharingPluginInterfaceEditAccountResult
    sharing_plugin_interface_edit_account (GtkWindow* parent,
    SharingAccount* account, ConIcConnection* con, gboolean* dead_mans_switch)
{
    msa_print("%s:%d:%s: try to edit account\n", __FILE__, __LINE__, __FUNCTION__);
    ULOG_DEBUG_L ("sharing_plugin_interface_edit_account");
    if (!account)
         return SHARING_EDIT_ACCOUNT_NOT_STARTED;
    
    return create_ui(parent, account, TRUE);
}

/**
 *  Function: Get albums from vk and set new albums option in sharing ui
 * */
gboolean
sharing_plugin_interface_update_options (SharingAccount *account,
                                         ConIcConnection *con,
                                         gboolean *cont,
                                         gboolean *dead_mans_switch,
                                         UpdateOptionsCallback update_options_callback,
                                         gpointer cb_data)
{
    ULOG_DEBUG_L ("%s:%d:%s(): start update", __FILE__, __LINE__, __FUNCTION__);
    msa_print("%s:%d:%s(): start update\n", __FILE__, __LINE__, __FUNCTION__);

    gboolean ret = FALSE;
    GSList *list_albums = NULL;

    gchar* account_name = sharing_account_get_username (account);

    if(!libvk_init(con, account_name)){
        return SHARING_SEND_ERROR_UNKNOWN;
    }

    /* authorize */
    gchar* params = sharing_account_get_param(account, NODE_SETTINGS);
    libvk_set_settings(params);
    g_free(params);

    /*  get list albums */
    if((libvk_getAlbums(&list_albums)) != SHARING_SEND_SUCCESS)
    {
        msa_print("%s:%d:%s: error: can't get album id\n", __FILE__, __LINE__, __FUNCTION__);
        ret = FALSE;
    } else
        ret = sharing_account_set_option_values(account, "album", list_albums);

    if (ret == TRUE) {
        libvk_get_settings (account);
    }
    libvk_uninit();
    
    /* Callback */
    void (*fp) (SharingPluginInterfaceUpdateOptionsResult, gpointer);
    if (update_options_callback != NULL) {
        fp = update_options_callback;
        if (ret)
            fp (SHARING_UPDATE_OPTIONS_SUCCESS, cb_data);
        else
            fp (SHARING_UPDATE_OPTIONS_ERROR_UNKNOWN, cb_data);
    } else {
        ULOG_DEBUG_L ("%s:%d:%s(): unknown callback", __FILE__, __LINE__, __FUNCTION__);
        msa_print("%s:%d:%s(): unknown callback\n", __FILE__, __LINE__, __FUNCTION__);
    }
    return ret;

}

void update_options_callback (SharingPluginInterfaceUpdateOptionsResult result,
                         gpointer cb_data)
{
    ULOG_DEBUG_L ("%s:%d:%s(): success finish?", __FILE__, __LINE__, __FUNCTION__);
    msa_print("%s:%d:%s(): success finish?\n", __FILE__, __LINE__, __FUNCTION__);
}


