#ifndef __MOBILBLOGG_H__
#define __MOBILBLOGG_H__

#include <glib.h>
#include <sharing-plugin-interface.h>
#include <conicconnection.h>

struct mobilblogg_St;
typedef struct mobilblogg_St mobilblogg_t;

typedef enum {
    MobilBloggNoError,
    MobilBloggConnectionError,
    MobilBloggCredentialsError,
    MobilBloggServerError,
    MobilBloggErrorCancelled,
} mobilblogg_error_code;

mobilblogg_t *mobilblogg_init(ConIcConnection *con, const gchar *username, const gchar *password);
mobilblogg_error_code mobilblogg_login(mobilblogg_t *mobblogg);
void mobilblogg_destroy(mobilblogg_t *mobblogg);
void mobilblogg_set_secretword (mobilblogg_t *mobblogg, const gchar *secretword);
mobilblogg_error_code mobilblogg_send (mobilblogg_t *mob, SharingTransfer *transfer, guint64 progress_start, guint64 progress_end, gboolean *dead_mans_switch, const gchar *right, SharingEntryMedia *media);

#endif

