/*
 * This file is part of sharing-plugin-blipfoto
 *
 * Copyright (C) 2010 Dave Elcock. All rights reserved.
 *
 * This code is licensed under a MIT-style license, that can be
 * found in the file called "COPYING" in the root directory.
 *
 */

#ifndef __BLIP_CONNECTION_H__
#define __BLIP_CONNECTION_H__

#include <glib.h>

#include "blip_error.h"

G_BEGIN_DECLS

        struct BlipConnection_s;
typedef struct BlipConnection_s * BlipConnection;

enum BlipConnectionStatus_e
{
    BLIP_CONNECTION_CONTINUE,
    BLIP_CONNECTION_CANCEL,
};
typedef enum BlipConnectionStatus_e BlipConnectionStatus;

/**
 * @param [in] client_data
 *   This is the unmodified client data passed into
 *   blip_connection_set_upload_callback().
 * @param [in] progress
 *   Progress through the upload in the range 0 to 1 where 0 means no progress,
 *   and 1 means complete.
 * @return
 *   If progress should continue, return BLIP_CONNECTION_OK. If the upload
 *   should be cancelled, return BLIP_CONNECTION_CANCEL.
 */
typedef BlipConnectionStatus (*BlipConnectionUploadCallback)(void * client_data,
                                                             gdouble progress);

BlipConnection blip_connection_create();

void blip_connection_free(BlipConnection conn);

gchar* blip_connection_go(BlipConnection conn,
                          const gchar* url,
                          BlipError * oError);

void blip_connection_post_text(BlipConnection conn,
                               const gchar * fieldName,
                               const gchar * fieldText);

void blip_connection_post_file(BlipConnection conn,
                               const gchar * fieldName,
                               const gchar * fileFullPath);

void blip_connection_set_upload_callback(BlipConnection conn,
                                         BlipConnectionUploadCallback,
                                         void * client_data);

G_END_DECLS

#endif // ! __BLIP_CONNECTION_H__
