#ifndef BOARDHANDLER_H
#define BOARDHANDLER_H
#include <QtCore>
#include <QDebug>
#include <QByteArray>
#include <string.h>
#include <vector>
#include "buttons.h"
#include <QObject>


class BoardHandler
{
public:

    BoardHandler();

    ~BoardHandler();

    /*
    * GetButtonType(int Xpos, int Ypos)
    * parameter button position on board.
    * returns button type if there is button. else it will return 0.
    * Returns buttontype.
    */
    char GetButtonType(int Xpos, int Ypos);

    int GetButtonOwner(int Xpos, int Ypos);
    int GetButtonRawPosition(int Xpos, int Ypos);

    /*
    * MoveButton(startPosition,finalPosition)
    * Moves button in chessboard,
    * give button start position and final position.
    * MoveButton returns 1 if move was ok, else return -1.
    */
    int MoveButton(int startXpos, int startYpos, int finalXpos, int finalYpos);

    int GetButtonXPosition(int RawXPosition);
    int GetButtonYPosition(int RawYPosition);
    int IsButtonAlive(int RawYPosition);
    int GetPossibleMovePlace(int position);

    int MoveChecker(int startXpos, int startYpos, int finalXpos, int finalYpos);
    void PaintPossibleMoves(int startXpos, int startYpos);

    int CheckSoldier(int startXpos, int startYpos, int finalXpos, int finalYpos);
    int CheckKing(int startXpos, int startYpos, int finalXpos, int finalYpos);
    int CheckRook(int startXpos, int startYpos, int finalXpos, int finalYpos);
    int CheckBishop(int startXpos, int startYpos, int finalXpos, int finalYpos);
    int CheckQueen(int startXpos, int startYpos, int finalXpos, int finalYpos);
    int CheckKnight(int startXpos, int startYpos, int finalXpos, int finalYpos);

    /*
    * SetDefaults()
    * set every button its default position
    * Use this when start a new game, or reset board.
    */
    void SetDefaults(void);

    void AddButton(Buttons* pButton);




private:
       QByteArray ButtonArray; //shakkilaudan nappulat
       int PossibleMove[65];
       int hautuumaaX;
       int hautuumaaY;


       std::vector<Buttons*>	m_arrButtons;

};

#endif // BOARDHANDLER_H
