/*
 *  Copyright (C) 2007 Savoir-Faire Linux inc.
 *  Author: Pierre-Luc Beaudoin <pierre-luc.beaudoin@savoirfairelinux.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dbusmanagerimpl.h>
#include "global.h"
#include "manager.h"

#include "callmanager.h"
#include "configurationmanager.h"

const char* DBusManagerImpl::SERVER_NAME = "org.sflphone.SFLphone";

int
DBusManagerImpl::exec()
{

    DBus::default_dispatcher = &_dispatcher;

    DBus::Connection conn = DBus::Connection::SessionBus();
    conn.request_name (SERVER_NAME);

    _callManager = new CallManager (conn);
    _configurationManager = new ConfigurationManager (conn);
    _instanceManager = new Instance (conn);

    // Register accounts
    Manager::instance().initRegisterAccounts(); //getEvents();

    _debug ("Starting DBus event loop\n");
    _dispatcher.enter();

    return 1;
}

void
DBusManagerImpl::exit()
{

    _dispatcher.leave();

}

