#include "browser.h"
#include "ui_browser.h"

#include <QNetworkProxyFactory>
#include <QCoreApplication>

Browser::Browser(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Browser)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    QNetworkProxyFactory::setUseSystemConfiguration (true);
    QWebSettings::globalSettings()->setAttribute(QWebSettings::PluginsEnabled, true);
    QWebSettings::globalSettings()->setAttribute(QWebSettings::AutoLoadImages, true);

    WebPage *page = new WebPage(ui->webView);
    ui->webView->setPage(page);

    connect(ui->webView, SIGNAL(loadProgress(int)), ui->progressBar, SLOT(setValue(int)));
    connect(ui->actionBack, SIGNAL(triggered()), ui->webView, SLOT(back()));
    connect(ui->actionForward, SIGNAL(triggered()), ui->webView, SLOT(forward()));
    connect(ui->actionRefresh, SIGNAL(triggered()), ui->webView, SLOT(reload()));
    connect(ui->stopButton, SIGNAL(clicked()), ui->webView, SLOT(stop()));
    connect(ui->webView, SIGNAL(loadStarted()), this, SLOT(onLoadStarted()));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onLoadFinished(bool)));

#ifdef Q_WS_MAEMO_5
    ui->stopButton->setText("");
    ui->stopButton->setIcon(QIcon::fromTheme("general_stop"));
//    setAttribute(Qt::WA_Maemo5StackedWindow);
    QWebViewSelectionSuppressor *suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
#endif
}

Browser::~Browser()
{
    delete ui;
}

void Browser::openPage(Browser::Pages page)
{
    QString url;
    switch (page) {
    case Browser::Facebook:
        url = "https://www.facebook.com/servpubblico";
        break;
    case Browser::Twitter:
        url = "https://twitter.com/serv_pubblico";
        break;
    case Browser::Youtube:
        url = "http://www.youtube.com/user/Serviziopubblico/featured";
        break;
    case Browser::ServizioPubblico:
        url = "http://www.serviziopubblico.it/";
        break;
    case Browser::DiTv:
        url = "http://maemoincrys.altervista.org/tv.html";
        break;
    case Browser::Telecupole:
        url = "http://maemoincrys.altervista.org/cupole.html";
        break;
    case Browser::Vauro:
        url = "http://vauro.globalist.it/";
        break;
    }
    ui->webView->setUrl(QUrl(url));
}

void Browser::openPage(QString url)
{
    ui->webView->setUrl(QUrl(url));
}

void Browser::onLoadStarted()
{
    ui->widget->show();
}

void Browser::onLoadFinished(bool)
{
    ui->widget->hide();
}

QWebView* Browser::webView()
{
    return ui->webView;
}

WebPage::WebPage(QWebView *parent) :
    QWebPage(parent)
{}

QString WebPage::userAgentForUrl(const QUrl &url) const
{
#ifdef Q_WS_MAEMO_5
    Q_UNUSED(url)
    return QString("Firefox/3.5 Maemo Browser 1.7.4.8 RX-51 N900");
#else
    return QWebPage::userAgentForUrl(url);
#endif
}

void Browser::on_actionVisualizza_nel_browser_triggered()
{
    QDesktopServices::openUrl(ui->webView->url());
}
