#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "puntateform.h"
#include "credits.h"
#include "optionsform.h"

#include <QtCore/QCoreApplication>
#include <QProcess>
#include <QtGui/QMessageBox>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow),
      puntateForm(0),
      credits(0),
      optionsForm(0),
      browser(0)
{
    ui->setupUi(this);

    setAttribute(Qt::WA_Maemo5StackedWindow);

    puntateForm = new PuntateForm(this);
    credits = new Credits(this);
    optionsForm = new OptionsForm(this);
    browser = new Browser(this);
}

MainWindow::~MainWindow()
{
    if (puntateForm) delete (puntateForm);
    if (credits) delete (credits);
    if (optionsForm) delete (optionsForm);
    if (browser) delete (browser);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_capital_clicked()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/capital.sh");
    process.waitForFinished();
}

void MainWindow::on_cielo_clicked()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/cielo.sh");
    process.waitForFinished();
}

void MainWindow::on_ditv_clicked()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::DiTv);
    browser->show();
}

void MainWindow::on_kataweb_clicked()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/kataweb.sh");
    process.waitForFinished();
}

void MainWindow::on_rtv_clicked()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/rtv38.sh");
    process.waitForFinished();
}

void MainWindow::on_telecupole_clicked()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::Telecupole);
    browser->show();
}

void MainWindow::on_actionYoutube_triggered()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::Youtube);
    browser->show();
}

void MainWindow::on_actionOpzioni_triggered()
{
    optionsForm->show();
}

void MainWindow::on_actionServizioPubblico_Online_triggered()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::ServizioPubblico);
    browser->show();
}

void MainWindow::on_actionRicorda_un_amico_triggered()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/ricorda.sh");
    process.waitForFinished();
}

void MainWindow::on_actionDonazione_triggered()
{
    QProcess process;
    process.start("sh /opt/serviziopubblico/script/donate.sh");
    process.waitForFinished();
}

void MainWindow::on_actionPuntate_triggered()
{
    puntateForm->show();
}

void MainWindow::on_actionCredits_triggered()
{
    credits->show();
}

void MainWindow::on_actionFacebook_triggered()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::Facebook);
    browser->show();
}

void MainWindow::on_actionTwitter_triggered()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::Twitter);
    browser->show();
}

void MainWindow::on_actionVauro_triggered()
{
    Browser *browser = new Browser(this);
    browser->openPage(Browser::Vauro);
    browser->show();
}
