#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
 @file: SysTest.py
  File is a part of Scribo Project
  Module implements add post from file
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 14.02.2010
"""

#import sys

from ldm.Message import Message
from ldm.Profile import main_prof
from ldm.Account import Account
from services.Dispatcher import dispatcher

from time import time, localtime
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysTest:
    """
    Class with test method for SendPost module
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """

        service = dispatcher.get_services()[0]
        acc = Account.register(service, "scribo_rpc")

        service = dispatcher.get_services()[1]
        ac1 = Account.register(service, "sscribo")

        #acc.username = "scribo_rpc"
        acc.passwd = "test123"

        #ac1.username = "sscribo"
        ac1.passwd = "test123"

        tm_ = localtime(time())
        date = "%s-%s-%s %s:%s:%s" % (tm_.tm_year,
            tm_.tm_mon, tm_.tm_mday, tm_.tm_hour, tm_.tm_min, tm_.tm_sec)

        fo_ = open('./data/TestRes.txt', 'a+')
        fo_.write('\n=====System testing at time %s=====\n' % (date))
        print ('\n=====System testing at time %s=====\n' % (date))

        fo_.write('\nChecking Add Account Scenario ')
        print '\nChecking Add Account Scenario '
        try:
            main_prof.add_account(ac1)
        except:
            print "we have Blurty )"
        try:
            main_prof.add_account(acc)
        except:
            print "already have"
            acc = Account.find(type(acc), acc.username)
        try:
            main_prof.set_def_account(acc)
        except:
            fo_.write('ERROR\n')
            print "ERROR\n"
        else:
            fo_.write('OK\n')
            print "OK\n"
        fo_.close()

    mes1 = Message()
    mes2 = Message()
    alf = "QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm0123456789"



    def send_post(self):
        """ 
        method 4 testing send post scenario 
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Send post Scenario with LiveJournal:\n')
        print '\nChecking Send post Scenario with LiveJournal:\n'

        fo_ = open('./data/testMes.txt', 'r')

        all_lines = fo_.readlines()
        tm_ = localtime(time())
        date = "%s-%s-%s %s:%s" % (tm_.tm_year,
            tm_.tm_mon, tm_.tm_mday, tm_.tm_hour, tm_.tm_min)
        header = all_lines[0] + date
        body = all_lines[1]

        fo_.close()

        mes = Message()
        mes.title = unicode(header, errors='replace')
        mes.text = unicode("\"><script>alert()</script> " +
                            body, errors='replace')
        mes.tags = unicode("'; DROP TABLE Messages;'", errors='replace')

        fq_.write(' -normal post ')
        print ' -normal post '

        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"



        self.mes1.title = ''
        self.mes1.text = all_lines[2]

        fq_.write(' -post without title ')
        print ' -post without title '
        try:
            main_prof.def_account.add_post(self.mes1)
            res = main_prof.def_account.send_post(self.mes1)
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        fo_.close()
        fq_.close()

    def send_random_post(self):
        """ 
        testing send post scenario with random values
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write(' -random generated post ')
        print ' -random generated post '
        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += (self.random_str(50) + "<br>" + self.random_str(i)
                     + "<br>" + self.random_str(50) + "<br>")

        mesr = Message()
        mesr.title = unicode(header, errors='replace')
        mesr.text = unicode("\"><script>alert()</script> " +
                             body, errors='replace')
        mesr.tags = unicode(self.random_str(5), errors='replace')
        try:
            main_prof.def_account.add_post(mesr)
            res = main_prof.def_account.send_post(mesr)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
            fq_.close()

    def send_blurty_post(self):
        """ 
        testing send post scenario with random values
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Send post Scenario with Blurty: ')
        print '\nChecking Send post Scenario with Blurty: '
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "sscribo"):
                if(acc.service_id == "BlurtyAccount"):
                    main_prof.set_def_account(acc)


        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += self.random_str(100) + self.random_str(i) + "<br>"

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.text = unicode("\"><script>alert()</script> " +
                             body, errors='replace')
        mesa.tags = unicode(self.random_str(5), errors='replace')
        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR - can't add post\n"
        else:
            fq_.write('OK\n')
            print "OK\n"

        accs = main_prof.get_accounts()

        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)
        fq_.close()


    def send_dream_post(self):
        """ 
        testing send post scenario with random values to dreamwaccount
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Send post Scenario with Dreamwidth: ')
        print '\nChecking Send post Scenario with Dreamwidth: '
        service = dispatcher.get_services()[3]
        acc = Account.register(service, "scribo_rpc")
        acc.passwd = "test123"
        try:
            main_prof.add_account(acc)
        except:
            print "already added"
            acc = Account.find(type(acc), acc.username)
        main_prof.set_def_account(acc)

        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += (self.random_str(10) + " " + self.random_str(i) +
                    self.random_str(5) +
                    self.random_str(10) + " " + self.random_str(5) +
                    self.random_str(10) +
                    " " + self.random_str(5) + self.random_str(10) + " " +
                    self.random_str(5) + "<br>")

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.text = unicode("\"><script>alert()</script> " +
                             body, errors='replace')
        mesa.tags = unicode(self.random_str(5), errors='replace')
        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR - can't add post\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)
        fq_.close()


    def send_insane_post(self):
        """ 
        testing send post scenario with random values to dreamwaccount
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Send post Scenario with InsaneJournal: ')
        print '\nChecking Send post Scenario with InsaneJournal: '
        service = dispatcher.get_services()[2]
        acc = Account.register(service, "scribo_rpc")
        acc.passwd = "test123"
        try:
            main_prof.add_account(acc)
        except:
            print "already added"
            acc = Account.find(type(acc), acc.username)
        main_prof.set_def_account(acc)

        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += (self.random_str(10) + " " + self.random_str(i) +
             self.random_str(5) + self.random_str(10) +
              " " + self.random_str(5) + self.random_str(10) +
               " " + self.random_str(5) + self.random_str(10) +
                " " + self.random_str(5) + "<br>")

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.text = unicode("\"><script>alert()</script> " +
                             body, errors='replace')
        mesa.tags = unicode(self.random_str(5), errors='replace')

        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR - can't add post\n"
        else:
            fq_.write('OK\n')
            print "OK\n"

        accs = main_prof.get_accounts()

        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)
        fq_.close()



    def send_big_post(self):
        """ 
        method 4 testing send post scenario with BIG post
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write(' -big post ')
        print ' -big post '
        fo_ = open('./data/bigPOST', 'r')

        all_lines = fo_.readlines()

        header = all_lines[0]
        body = all_lines[1]
        fo_.close()
        fo_ = open('./data/bigPOST', 'r')

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.title += unicode(" - ", errors='replace') + unicode(body,
                                                             errors='replace')

        all_lines = fo_.read()
        mesa.text = unicode(all_lines, errors='replace')
        fo_.close()
        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
            print res
        except:
            fq_.write('ERROR\n')
            print "ERROR - can't add post\n"
        else:
            fq_.write('OK\n')
            print "OK\n"

    def get_posts(self):
        """ 
        method 4 testing get posts from LiveJournal scenario 
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Get Posts Scenario from LJ: ')
        print '\nChecking Get Posts Scenario from LJ: '
        list1 = []
        out = open('./data/posts.txt', 'w')


        #uncomment to start stress testing

        #for i in range(1, 1000):
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list1 = main_prof.get_posts()
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"

        if len(list1) == 0:
            print 'There are no posts - look for bug!'

        for mess in list1:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()


            out.write('\n%s\n%s\n' % (title.encode("utf-8"),
                                       text.encode("utf-8")))
            if (mess == list1[0]):
                self.mes1.custom_id = mess.get_custom_id()
            if (mess == list1[1]):
                self.mes2.custom_id = mess.get_custom_id()
        out.close()

        fq_.write('\nChecking Get Posts Scenario from Blurty: ')
        print '\nChecking Get Posts Scenario from Blurty: '
        list1 = []
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "BlurtyAccount"):
                    main_prof.set_def_account(acc)
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list1 = main_prof.get_posts()
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        out1 = open('./data/blurty_posts.txt', 'w')
        if len(list1) == 0:
            print 'There are no posts - look for bug!'

        for mess in list1:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()


            out1.write('\n%s\n%s\n' % (title.encode("utf-8"),
                                        text.encode("utf-8")))
        out1.close()

        fq_.write('\nChecking Get Posts Scenario from insane: ')
        print '\nChecking Get Posts Scenario from insane: '
        list1 = []
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "InsanejAccount"):
                    main_prof.set_def_account(acc)

        try:
            main_prof.def_account.refresh_posts(self.callback)
            list1 = main_prof.get_posts()
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        out1 = open('./data/insane_posts.txt', 'w')
        if len(list1) == 0:
            print 'There are no posts - look for bug!'

        for mess in list1:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()


            out1.write('\n%s\n%s\n' % (title.encode("utf-8"),
                                        text.encode("utf-8")))
        out1.close()


        fq_.write('\nChecking Get Posts Scenario from dream: ')
        print '\nChecking Get Posts Scenario from dream: '
        list1 = []
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "DreamwAccount"):
                    main_prof.set_def_account(acc)
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list1 = main_prof.get_posts()
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        out1 = open('./data/dream_posts.txt', 'w')
        if len(list1) == 0:
            print 'There are no posts - look for bug!'

        for mess in list1:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()


            out1.write('\n%s\n%s\n' % (title.encode("utf-8"),
                                        text.encode("utf-8")))
        out1.close()

        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)





    def del_posted(self):
        """
        deleting our post from LJ
        """
        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Delete Post Scenario: ')
        print '\nChecking Delete Post Scenario: '
        try:
            main_prof.def_account.del_post(self.mes1)
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        print "deleted"
        fq_.close()

    def random_str(self, leng=20):
        """
        generating random symbol combination
        """
        if leng:
            return random.choice(self.alf) + self.random_str(leng - 1)
        else:
            return ""

    def edit_your_post(self):
        """
        trying to edit last post has been sent
        """

        fq_ = open('./data/TestRes.txt', 'a+')
        fq_.write('\nChecking Edit Post Scenario: ')

        print '\nChecking Edit Post Scenario: '
        fo_ = open('./data/testMes.txt', 'r')
        all_lines = fo_.readlines()

        tm_ = localtime(time())
        date = "%s-%s-%s %s:%s:%s" % (tm_.tm_year,
            tm_.tm_mon, tm_.tm_mday, tm_.tm_hour, tm_.tm_min, tm_.tm_sec)

        pwd = self.random_str(20)

        self.mes2.title = unicode(all_lines[3], errors='replace')
        self.mes2.text = unicode(all_lines[4] + "<br><br>", errors='replace')
        self.mes2.text += unicode("Your New password is " +
                                   pwd, errors='replace')
        self.mes2.tags = unicode("deleted", errors='replace')
        self.mes2.date = unicode(date, errors='replace')

        try:
            main_prof.def_account.edit_post(self.mes2)
        except:
            fq_.write('ERROR\n')
            print "ERROR\n"
        else:
            fq_.write('OK\n')
            print "OK\n"
        fq_.close()
        fo_.close()


    def callback(self):
        """ 
        callback 4 get_posts method 
        """
        print "getting posts..."


#creating class instance & calling its methods

T = SysTest()
T.send_post()
T.send_random_post()
T.send_big_post()
T.send_blurty_post()
T.send_dream_post()
T.send_insane_post()
T.get_posts()
T.del_posted()
T.edit_your_post()
print "FINISH!"
