#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
===============================================================
   This file contains functions to work with DreamWidth 
(clone of LiveJournal.com)
    
    http://www.dreamwidth.org/
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/03/28 $"
__copyright__ = ""
__license__ = "GPLv2"

from LivejAccount import LivejAccount

DREAM_SERVER = "http://www.dreamwidth.org/interface/xmlrpc:80"
DREAM_USERPICS = 'http://www.dreamwidth.org/userpic/'
DREAM_SHORT = "http://www.dreamwidth.org"

class DreamwAccount(LivejAccount):

    def __init__(self, id=None):
        super(DreamwAccount, self).__init__(id, DREAM_SERVER, DREAM_USERPICS)


    @staticmethod
    def get_name():
        """
        Get name of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) name of this service
        """

        return 'DreamWidth'


    @staticmethod
    def get_icon():
        """
        Get path to icon of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) path to icon of this service
        """

        return '../data/dreamw.png'

    def refresh_comments (self, callback, addit = None):
        pass

    def screen_comment (self, msg, addit = None):
        raise WarningExc("DreamAccount", "Operation not supported")

    def freeze_comment (self, msg, addit = None):
        raise WarningExc("DreamAccount", "Operation not supported")

    def send_comment (self, msg, parent, addit = None):
        raise WarningExc("DreamAccount", "Operation not supported")