#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
===============================================================
Class with test method for Message module
===============================================================
"""

from services.Dispatcher import dispatcher
from ldm.Message import Message
from FakeAccount import FakeAccount
from ScriboExc import WarningExc
import unittest


__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/07 $"
__copyright__ = ""
__license__ = "GPLv2"



class MessageTest(unittest.TestCase):
    """
    Class with test method for Message module
    """

    def setUp(self):
        """
        Init variables for test methods
        """

        self.msg = Message()
        self.str_list = [u'ololo',
                         None,
                         u'1"; DROP TABLE Messages;',
                         u"1'; DROP TABLE Messages;"
                         u'Hello World!',
                         u'русский текст',
                         u'외국인 텍스트',
                         u'النص الأجنبي',
                         u'étrangers texte',
                         u'90k_text ' * 10000,
                         u''
                        ]
        self.date_list = [
                          '0000-00-00 00:00:00',
                          None,
                          '1234:12:12 09:09:09',
                          '2010-02-07 16:44:30'
                         ]
        self.int_list = [0, 1, 7, 11111, 2732924]


    def test_title(self):
        """
        test for Message.title
        assigning strings
        """

        for i in self.str_list:
            self.msg.title = i
            self.assertEqual(i, self.msg.title)


    def test_text(self):
        """
        test for Message.text
        assigning strings
        """

        for i in self.str_list:
            self.msg.text = i
            self.assertEqual(i, self.msg.text)


    def test_date(self):
        """
        test for Message.date
        assigning strings
        """

        for i in self.date_list:
            self.msg.date = i
            self.assertEqual(i, self.msg.date)


    def test_path_to_ava(self):
        """
        test for Message.path_to_ava
        assigning strings
        """

        for i in self.str_list:
            self.msg.path_to_ava = i
            self.assertEqual(i, self.msg.path_to_ava)


    def test_tags(self):
        """
        test for Message.tags
        assigning strings
        """

        for i in self.str_list:
            self.msg.tags = i
            self.assertEqual(i, self.msg.tags)


    def test_url(self):
        """
        test for Message.url
        assigning strings
        """

        for i in self.str_list:
            self.msg.url = i
            self.assertEqual(i, self.msg.url)


    def test_custom_id(self):
        """
        test for Message.custom_id
        assigning strings
        """

        for i in self.str_list:
            self.msg.custom_id = i
            self.assertEqual(i, self.msg.custom_id)


    def test_unread_cmnts(self):
        """
        test for Message.unread_cmnts
        assigning strings
        """

        for i in self.int_list:
            self.msg.unread_cmnts = i
            self.assertEqual(i, self.msg.unread_cmnts)

        for i in self.str_list:
            self.assertRaises(WarningExc, self.msg.set_unread_cmnts, i)


    def test_type(self):
        """
        test for Message.type
        assigning strings
        """

        for i in self.int_list:
            self.msg.type = i
            self.assertEqual(i, self.msg.type)

        for i in self.str_list:
            self.assertRaises(WarningExc, self.msg.set_type, i)


    def test_del_message(self):
        """
        test for Message._del_message
        delete object from DB and trying to load it
        """

        id = self.msg.id
        self.msg._del_message()
        self.assertRaises(WarningExc, Message, id)


    def test_comments(self):
        """
        test for Message.add_comment, Message.get_comments, Message.read(partly)
        building 2 level comment tree, getting comments and comments on 
        comments, getting number of unread comments for current post, marking
        some comments as read/unread 
        """

        acc = FakeAccount()
        acc.add_post(self.msg)
        self.assertFalse(len(self.msg.comments))
        for _ in xrange(5):
            new_comment = Message()

            self.msg.add_comment(new_comment)
            for _ in xrange(6):
                comm_on_comment = Message()
                new_comment.add_comment(comm_on_comment, self.msg)

            self.assertEqual(len(new_comment.comments), 6)

        self.assertEqual(len(self.msg.comments), 5)

        self.assertEqual(self.msg.unread_cmnts, 35)
        self.msg.comments[2].read = True
        self.assertEqual(self.msg.unread_cmnts, 34)
        self.msg.comments[2].comments[1].read = True
        self.assertEqual(self.msg.unread_cmnts, 33)
        self.msg.comments[0].comments[0].read = True
        self.assertEqual(self.msg.unread_cmnts, 32)
        self.msg.comments[0].read = True
        self.assertEqual(self.msg.unread_cmnts, 31)
        self.msg.comments[0].comments[0].read = False
        self.assertEqual(self.msg.unread_cmnts, 32)
        self.msg.comments[0].comments[0].read = False
        self.assertEqual(self.msg.unread_cmnts, 32)


    def test_del_msg_tree(self):
        """
        test for Message.del_msg_tree
        creating post with two level comments and deleting them from DB
        """

        self.test_comments()
        comment1 = self.msg.comments[0]
        id1 = comment1.id
        id11 = comment1.comments[0].id
        id2 = self.msg.comments[1].id
        comment1.del_msg_tree()
        self.assertRaises(WarningExc, Message, id1)
        self.assertRaises(WarningExc, Message, id11)
        self.assertNotEqual(id1, self.msg.comments[0].id)
        self.assertEquals(len(self.msg.comments), 4)
        id = self.msg.id
        self.msg.del_msg_tree()
        self.assertRaises(WarningExc, Message, id)
        self.assertRaises(WarningExc, Message, id2)


    def test_poster(self):
        """
        test for Message.poster
        try to assign diffrent values: correct and not corrent 
        """

        acc = FakeAccount()
        self.msg.poster = acc
        self.assertEqual(acc, self.msg.poster)

        self.assertRaises(WarningExc, self.msg.set_poster, "string")
        self.assertRaises(WarningExc, self.msg.set_poster, 1414)
        self.assertRaises(WarningExc, self.msg.set_poster, True)

        self.assertEqual(acc, self.msg.poster)


    def test_journal(self):
        """
        test for Message.journal
        try to assign diffrent values: correct and not corrent
        """

        acc = FakeAccount()
        self.msg.journal = acc
        self.assertEqual(acc, self.msg.journal)

        self.assertRaises(WarningExc, self.msg.set_journal, "string")
        self.assertRaises(WarningExc, self.msg.set_journal, 1414)
        self.assertRaises(WarningExc, self.msg.set_journal, True)

        self.assertEqual(acc, self.msg.journal)



    def test_parent(self):
        """
        test for Message.parent
        try to assign diffrent values: correct and not corrent
        """

        parent = Message()
        self.msg.parent = parent
        self.assertEqual(parent, self.msg.parent)

        self.assertRaises(WarningExc, self.msg.set_parent, "string")
        self.assertRaises(WarningExc, self.msg.set_parent, 1414)
        self.assertRaises(WarningExc, self.msg.set_parent, True)

        self.assertEqual(parent, self.msg.parent)


    def test_read(self):
        """
        test for Message.read
        try to assign diffrent values: correct and not corrent
        """

        self.msg.read = True
        self.assertTrue(self.msg.read)

        self.msg.read = False
        self.assertFalse(self.msg.read)

        self.assertRaises(WarningExc, self.msg.set_read, "string")
        self.assertRaises(WarningExc, self.msg.set_read, 1414)
        self.assertRaises(WarningExc, self.msg.set_read, Message)

        self.assertFalse(self.msg.read)


if __name__ == '__main__':
    unittest.main()
