"""
 @file: SysPT.py
  File is a part of Scribo Project
  Module implements group and friends test scenariouses
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 9.03.2010
"""

import sys
sys.path.append("..")
sys.path.append("../ldm")
sys.path.append("../ui")
sys.path.append("../services")

from Message import Message
from Profile import *
from Account import *
from LivejAccount import *
from time import *
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysFT:
    """
    Class with test method for friends modules
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        acc = LivejAccount()
        acc.set_option('proxy', '172.20.3.1:81')
        acc.username = "scribo_rpc"
        acc.passwd = "test123"

        try:
            main_prof.add_account(acc)
        except:
            print "already have"
            acc = Account.find(type(acc), acc.username)
        main_prof.set_def_account(acc)

    def get_friends_list(self):
        """
        test of getting list of friends
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Get Friends List Scenario with LiveJournal: ')

        try:
            main_prof.def_account.refresh_friends_list()
            list = main_prof.def_account.get_option('friends')
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        out = open('./data/friends.txt', 'w')

        for mess in list:
            print mess
            out.write('\n%s\n' % (mess))

        out.close()
        f1.close()


    def get_readers_list(self):
        """
        test of getting list of readers of our blog
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Get Readers List Scenario with LiveJournal: ')

        try:
            main_prof.def_account.refresh_friends_list()
            list = main_prof.def_account.get_readers()
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        out = open('./data/readers.txt', 'w')

        for mess1 in list:
            print mess1
            out.write('\n%s\n' % (mess1))
        f1.close()
        out.close()

    def add_my_friend(self):
        """
        adding a new fri(e)nd
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Add Friend Scenario with LiveJournal: ')

        aco = LivejAccount()
        aco.username = "maemoblogs"
        try:
            main_prof.def_account.add_friend(aco)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        print "added\n"
        f1.close()


    def kill_friend(self):
        """
        testing killing a friend
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Delete Friend Scenario with LiveJournal: ')

        aco = LivejAccount()
        aco.username = "maemoblogs"
        try:
            main_prof.def_account.remove_friend(aco)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        print "killed\n"
        f1.close()

    def refreshko(self):
        """
        trying to get friends posts
        """
        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking get friends posts Scenario with LiveJournal: ')

        try:
            fp = main_prof.def_account.refresh_friends_page(self.callback)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')
        print fp
        f1.close()

    def inboxo_O(self):
        """
        testing experimental inbox
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking inbox Scenarios with LiveJournal:\n')

        msgg = Message()
        msgg.title = unicode("hallou")
        msgg.text = unicode("tyu ")

        aco = LivejAccount()
        aco.username = "maemoblogs"
        msgg.poster = aco

        f1.write(' -add message to inbox ')

        try:
            main_prof.def_account.add_inbox(msgg)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        f1.write(' -add message to outbox ')
        try:
            main_prof.def_account.add_outbox(msgg)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        out = open('./data/inbox_data.txt', 'w')

        f1.write(' -get message from inbox ')

        try:
            inba = main_prof.def_account.get_inbox()
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        print inba
        out.write('\n%s\n' % (inba))

        f1.write(' -get message from outbox ')

        try:
            inba = main_prof.def_account.get_outbox()
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        print inba
        out.write('\n%s\n' % (inba))

        out.close()

        f1.close()

    def callback(self):
        """
        callback where it is needed
        """
        print "callback!"



a = SysFT()
"""
testing methods, that had been described above
stress test quoted, unquote to run
"""
"""
for i in range(1, 1000):
    a.get_friends_list()
    a.add_my_friend()
    a.kill_friend()
"""
a.get_friends_list()
a.get_readers_list()
a.add_my_friend()
a.kill_friend()
a.refreshko()
a.inboxo_O()
print "!!!"
