#!/usr/bin/env python

"""
===============================================================
    Contains definition of class Profile
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 18 $"
__date__ = "$Date: 2010/02/06 $"
__copyright__ = ""
__license__ = "GPLv2"

import sys
sys.path.append("..")

from ScriboExc import WarningExc
from Structure import Structure
from Message import Message, POST
from Account import Account
from SqlDriver import sql_driver, SQL_PROFILE_FIELDS


class Profile (Structure):

    """
        Class contains user profile and profiles of friends (in future). 
    
    @exception WarningExc All methods can raise WarningExc.
    @author Mezhenin Artoym <mezhenin@cs.karelia.ru> 
    @version 0.3
    @date 2010/01/12
    """

    #def __new__(cls, id=None):
    #    return super(Profile, cls).__new__(cls, id)


    def __init__(self, id=None):
        """
        Constuctor for class.
        
        @param id (string) app_id of profile in table. If there is no record
                           with such app_id it will be created.
        @return None
        @todo test
        """
        super(Profile, self).__init__("Profiles", id)


    """
    ===============================================================
        Getter methods
    ===============================================================
    """

    def get_accounts(self):
        """
        Get list of accounts in this profile.

        @return (list) a list of Account instance
        @todo test
        """
        from Account import Account

        query = 'SELECT id FROM Accounts WHERE prof=?'

        id_list = sql_driver.select_mcmd(query, (self._id,))

        accounts = []
        for i in id_list:
            accounts.append(Account(int(i[0])))

        return accounts

    def get_def_account(self):
        """
        Get field from Profiles table.

        @return (Account) account by default
        @todo test
        """
        from Account import Account
        res = self._get_field("def_account")
        if res:
            return Account(int(res))

        return None


    def get_posts(self):
        """
        Get list of posts from all account in this profile
        @return (list) list of Message instances
        @todo test
        """
        acc_list = self.accounts

        if not acc_list:
            return None

        """
        compose a complex query to the database that would select 
        all the posts belong to one of the profile accounts
        """

        #SELECT id from messages  order by  date desc, id

        cmd = "SELECT id FROM Messages WHERE type=? AND ( journal=?"
        for i in xrange(1, len(acc_list)):
            cmd += " OR journal=?"

        cmd += ") ORDER BY date DESC, id DESC"

        arg_list = [POST, ]
        for i in acc_list:
            arg_list.append(i.id)

        # get a list of id of posts
        id_list = sql_driver.select_mcmd(cmd, arg_list)

        # create list of Messages from id's 
        post_list = []
        for i in id_list:
            post_list.append(Message(i[0]))

        return post_list

    """
    ===============================================================
        Setter methods
    ===============================================================
    """

    def set_def_account(self, value):
        """
        Change field value in Profiles table.

        @param value (Account) account to be set as default for this profile
        @exception WarningExc if value is not Account, or value wasn't added to
                   this profile
        @return None
        """
        if value == None:
            self._set_field("def_account", None)
        elif value.prof == self:
            self._set_field("def_account", value._id)
        else:
            raise WarningExc("Profile setter",
                             "value is not a memder of this profile")

    """
    ===============================================================
        Init getter/setter  methods
    ===============================================================
    """
    ## property
    accounts = property(get_accounts)
    ## property
    def_account = property(get_def_account, set_def_account)

    """
    ===============================================================
        Other methods
    ===============================================================
    """
    def add_account(self, acc, protected=True):
        """
        Add account to this profile.
        
        @param acc (Account) account we want to add 
        @return None
        """
        if protected:
            same_acc = Account.find(type(acc), acc.username, self)
            if same_acc:
                raise WarningExc('Profile add_account',
                                 'Same account already exists')
        acc.prof = self


    def del_profile(self):
        """
        Delete this profile with all accounts from DB
        
        @return None
        """
        acc_list = self.accounts
        for i in acc_list:
            i.del_account()

        self._del_struct()


    def copy(self):
        """
        Make full copy of this profile.
        
        @return (Profile) new profile with exact values
        """

        return Profile(self._copy_fields(SQL_PROFILE_FIELDS))


"""
Init profile of user
"""
main_prof = Profile(1)
