#!/usr/bin/env python

"""
===============================================================
    This file contains bug tracker for Scribo project
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 8 $"
__date__ = "2010/01/08"
__copyright__ = ""
__license__ = "GPLv2"

import sys
import traceback
import hashlib


from PyQt4 import QtGui


#sys.path.append("./bugz")
from bugz.bugzilla import *

#test bugzilla url "https://landfill.bugzilla.org/bugzilla-3.4-branch/"

bugzilla_opts = {
                 'base_url': 'http://oss.fruct.org/bugzilla/',
                 #'proxy': 'http://host:port'
                 'user': 'scribo.bugs@oss.fruct.org',
                 'password': 'bugsforfree',
                 'product': 'scribo',
                 'component': 'unspecified',
                 'product_ver': "0.2" #NOTE: this value will be used as product
                                      #      version in Bugzgilla system, but
                                      #      not version in unique title  
                }



class BugReporter(object):

    """
    Class BugReporter create report of crashes and send it to Bugzilla. To post
    bugs it use XML-RPC and Bugzilla API.   
    
    @author Mezhenin Artoym <mezhenin@cs.karelia.ru> 
    @version 0.1
    @date 2010/01/08 
    """

    def __init__(self, exc, build_ver):
        """
        Constuctor for class.
        
        @param exc (Exception) Exception that was raised
        @param build_ver (string) product version, used to create unique string
        @return None
        @todo test
        """
        #aa, bb, tb = sys.exc_info()
        '''
        try:
            app = QtGui.QApplication(sys.argv)
        except RuntimeError:
            pass
        '''
        tb = sys.exc_info()[2]

        report_body = traceback.format_exc()

        print report_body # print for developers

        stack = traceback.extract_tb(tb)

        last_file = os.path.split(stack[-1][0])[1]

        # calculation hash for unique title, removing path to files from 
        # traceback
        edited_stack = []
        for i in stack:
            file_name = os.path.split(i[0])[1]
            edited_stack.append(((file_name,) + i[1:]))

        hash = hashlib.md5(repr(edited_stack)).hexdigest()

        # creating unique title
        report_title = '$V%s:%s:%s:%s:%s$' % (build_ver,
                                              last_file,
                                              stack[-1][2],
                                              str(stack[-1][1]),
                                              hash)

        if not self.user_confurmed(report_title):
            return

        from ConfigDriver import config

        bugz = Bugz(bugzilla_opts['base_url'],
                    bugzilla_opts['user'],
                    bugzilla_opts['password'],
                    forget=True,
                    proxy=config.get('Main', 'proxy'))

        res = bugz.search(report_title)
        if res:
            if 'RESOLVED' == res[0]['status']:
                # tell user, that bug is resolved
                info = "This bag has been fixed. For more information see " + \
                       bugzilla_opts['base_url'] + "show_bug.cgi?id=" + \
                       res[0]['bugid']

                QtGui.QMessageBox.information(None,
                                              "Bug Report",
                                              info,
                                              QtGui.QMessageBox.Ok)

            else:
                # we add new comment to first bugreport in list
                bugz.modify(int(res[0]['bugid']),
                            report_title,
                            report_body)
        else:
            #TODO: fix post funct and check answer, and version
            bugz.post(bugzilla_opts['product'],
                      bugzilla_opts['component'],
                      report_title,
                      report_body,
                      version=bugzilla_opts['product_ver'])


    def user_confurmed(self, msg):
        """
        Ask for confirmation to send bug report
        
        @return: (bool) True if user agree to send report
        """
        ret = QtGui.QMessageBox.question(None,
                                   "Bug Report",
                                   "Problem with: " + msg +
                                   "\nSend bug report?",
                                   QtGui.QMessageBox.Yes,
                                   QtGui.QMessageBox.No)

        if QtGui.QMessageBox.Yes == ret:
            return True

        return False

    def file_name(self):
        pass
