#!/usr/bin/env python
""" 
 @file: RepeatPost.py
  File is a part of Scribo Project
  Module implements repeating send posts from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 26.06.2010
"""
import sys
#sys.path.append("./src/services")
sys.path.append("./src/ldm")

from PyQt4 import QtCore
from PyQt4 import QtGui

#from HomePage import home_window
from MainWindow import *
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/26 $"
__copyright__ = ""
__license__ = "GPLv2"

class RepeatPost(MainWindow):
    """
    class for window with a tree accounts
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent, msg):
        """ 
        initialization "tree of messages" window
        @return
        """
        super(RepeatPost,self).__init__(parent)
        self.mes = msg
        self.centr_widg = QtGui.QWidget(self)
        self.tree_view = self.tree_view_acc()
        self.parent = parent
        #super(RepeatPost, self).create_actions()
        title = QtGui.QLabel(self.tr("Select accounts and groups for sending"), self)
        title.setAlignment(QtCore.Qt.AlignLeft)
        toolbar = self.create_toolbar()
        self.vbox = QtGui.QVBoxLayout()
        self.hbox = QtGui.QHBoxLayout()
        self.hbox.addWidget(toolbar)
        self.hbox.addSpacing(10)
        self.vbox.addWidget(title)
        self.vbox.addWidget(self.tree_view)
        self.hbox.addLayout(self.vbox)
        self.centr_widg.setLayout(self.hbox)
        self.setCentralWidget(self.centr_widg)
        self.show()

    def create_toolbar(self):
        """
        create toolbar for window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        self.send_act = QtGui.QToolButton(self.centr_widg)
        self.send_act.setIcon(QtGui.QIcon(self.tr("../data/en/send_post.png")))
        self.send_act.setText(self.tr("Send"))
        self.send_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.send_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.send_act, QtCore.SIGNAL("clicked()"), self.send_selected)
        file_tool_bar.addWidget(self.send_act)
        #self.disconnect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
        #             main_window.home_window)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                     self.home_window)
        return file_tool_bar

    def tree_view_acc(self):
        tree_widget = QtGui.QTreeWidget()
        header = QtCore.QStringList(self.tr("Service"))
        header.append(self.tr("Login"))
        tree_widget.setHeaderLabels(header)
        tree_widget.setColumnCount(2)
        tree_widget.setSelectionMode(QtGui.QAbstractItemView.MultiSelection)
        accounts = []
        self.all_acc = []
        list_acc = main_prof.accounts
        index = 0
        for acc in list_acc:
            self.all_acc.append(acc)
            path_icon = acc.get_icon()

            self.login = QtGui.QTreeWidgetItem(tree_widget)
            self.login.setFlags(QtCore.Qt.NoItemFlags| QtCore.Qt.ItemIsEnabled)
            # if user haven't userpic on service, it isn't added. 
            if path_icon:
                self.login.setIcon(0, QtGui.QIcon(QtCore.QString(path_icon)))
            else:
                self.login.setIcon(0, QtGui.QIcon())

            self.login.setText(1, acc.username)
            self.login.setData(1, QtCore.Qt.DisplayRole, QtCore.QVariant(acc.username))

            child_login = QtGui.QTreeWidgetItem(self.login)

            child_login.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled | QtCore.Qt.ItemIsSelectable)
            child_login.setText(1, acc.username)

            child_login.setData(1, QtCore.Qt.CheckStateRole, QtCore.QVariant(QtCore.Qt.Unchecked))
            child_login.setData(0, QtCore.Qt.UserRole, QtCore.QVariant(index))
            index = index + 1

            #if login has group...
            groups = acc.get_journals()
            if groups:
                len_groups = len(groups)
            else:
                len_groups = 0
            for l in xrange(len_groups):
                group_login = QtGui.QTreeWidgetItem(self.login)
                group_login.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled |QtCore.Qt.ItemIsSelectable)
                group_login.setText(1, groups[l].username)
                group_login.setData(1, QtCore.Qt.CheckStateRole,
                                     QtCore.QVariant(QtCore.Qt.Unchecked))
                group_login.setData(0, QtCore.Qt.UserRole, QtCore.QVariant(index))
                self.all_acc.append(groups[l])
                index = index + 1

            accounts.append(self.login)
        tree_widget.insertTopLevelItems(0, accounts)
        self.connect(tree_widget,
                      QtCore.SIGNAL("itemActivated (QTreeWidgetItem *,int)"), self.click_item)
        return tree_widget


    def click_item(self, item, column):
        if item.parent():
            select = item.data(1, QtCore.Qt.CheckStateRole).toString().toInt()[0]
            if select == QtCore.Qt.Checked:
                item.setData(1, QtCore.Qt.CheckStateRole,
                                         QtCore.QVariant(QtCore.Qt.Unchecked))
            else:
                item.setData(1, QtCore.Qt.CheckStateRole,
                                         QtCore.QVariant(QtCore.Qt.Checked))

    def send_selected(self):
        login_items = self.tree_view.selectedItems()
        flag_send = True
        if login_items:
            for item in login_items:
                msg_copy = self.mes.copy()
                acc = item.parent()

                #select root item
                if not acc:
                    if len(login_items) == 1:
                        QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Please, choose subitem for sending"),
                                                QtGui.QMessageBox.Yes)
                        return
                    continue
                first_child = acc.child(0)

                index = item.data(0, QtCore.Qt.UserRole).toString().toInt()[0]
                send_journal = self.all_acc[index]
                msg_copy.journal = send_journal

                num_acc = first_child.data(0, QtCore.Qt.UserRole).toString().toInt()[0]
                send_acc = self.all_acc[num_acc]
                try:
                    res = send_acc.send_post(msg_copy)
                except WarningExc, exc:
                    super(RepeatPost, self).show_warning(exc)
                    flag_send = False

                msg_copy.del_msg_tree()
        else:
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                          self.tr("Please, choose accounts or groups for sending"),
                                          QtGui.QMessageBox.Yes)
            return


        if flag_send:
            ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Post was sent"),
                                                QtGui.QMessageBox.Yes)
            self.parent.sending_post = True
        super(RepeatPost, self).home_window()

    def home_window(self):
        """
        check post on changing event
        """
        ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Post will be lost! "\
                                   "Continue? "),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
                return
        super(RepeatPost, self).home_window()
        
from AddPost import *
