#!/usr/bin/env python
""" 
 @file: TreeMessage.py
  File is a part of Scribo Project
  Module implements viewing tree of comments from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 06.01.2010
"""
import sys
#sys.path.append("./src/services")
#sys.path.append("./src/ldm")

from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/01/06 $"
__copyright__ = ""
__license__ = "GPLv2"

class TreeMessage(ToolbarWindow):
    """
    class for draw tree of comments window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  all handlers
    """
    def __init__(self, parent=None, msg="default"):
        """ 
        initialization "tree of messages" window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.msg = msg
        self.tree_view = self.tree_view_com(msg)
        self.create_actions()
        toolbar = self.create_toolbar()
        self.vbox = QtGui.QHBoxLayout()
        self.vbox.addWidget(toolbar)
        self.vbox.addWidget(self.tree_view)
        self.setLayout(self.hbox)


    def tree_view_com(self, msg):
        """ 
        fill tree of comments                                                   
        @param                                          
        @return
        """
        tree_view = QtGui.QTreeView(self)
        tree_view.setModel(MyModel(msg=msg))
        return tree_view

    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = super(AddPostWindow, self).create_toolbar()
        file_tool_bar.addAction(self.refresh_act)
        return file_tool_bar

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """

        self.refresh_act = QtGui.QAction(self.tr("&Refresh"), self)
        #self.refresh_act.setStatusTip(self.tr("Refresh"))
        self.refresh_act.setIcon(QtGui.QIcon("../data/refresh.png"))
        self.connect(self.refresh_act, QtCore.SIGNAL("triggered()"),
                     self.reload_window)

        super(TreeMessage, self).create_actions()


    def view_message(self):
        """  
        view choosing message
        @return
        """
        view_widg = ViewMessage(main_window)
        main_window.push_window(view_widg)

    def reload_window(self):
        """ 
        refresh tree                                                                     
        @param 
        @return
        """
        self.vbox.removeWidget(self.tree_view)
        self.tree_view = self.tree_view_com(self.msg)
        self.vbox.addWidget(self.tree_view)

class MyModel(QtCore.QAbstractItemModel):
    """
    class fill tree of comments
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  what's method's really needed?
     """
    def __init__(self, parent=None, msg=None):
        """ 
        initialization "tree of messages"
        @param parent = tree_view,
        @param msg   = viewing message
        @return
        """
        QtCore.QAbstractItemModel.__init__(self, parent)
        rootData = []
        rootData.append(QtCore.QVariant(self.tr("Author")))
        rootData.append(QtCore.QVariant(self.tr("Date")))
        rootData.append(QtCore.QVariant(self.tr("Title")))
        self.rootItem = TreeItem(rootData)
        self.setupModelData(msg, self.rootItem)

    def columnCount(self, parent):
        """
        columns count
        @param parent = parent item
        @return  count column from parent
        """
        if parent.isValid():
            return parent.internalPointer().columnCount()
        else:
            return self.rootItem.columnCount()

    def data(self, index, role):
        """
        get data from  item
        @param index = index of item
        @param role = visible or not visible data
        @return  data in item
        """
        if not index.isValid():
            return QtCore.QVariant()

        if role != QtCore.Qt.DisplayRole:
            return QtCore.QVariant()

        item = index.internalPointer()

        return QtCore.QVariant(item.data(index.column()))

    def flags(self, index):
        """
        get flags                                                                 
        @param index = index of item
        @return  flags of item (enabled or selectable)
        """
        if not index.isValid():
            return QtCore.Qt.ItemIsEnabled
        return QtCore.Qt.ItemIsEnabled | QtCore.Qt.ItemIsSelectable

    def headerData(self, section, orientation, role):
        """
        return header data
        @param section = column with header (visible)
        @param orientation = Horizontal or Vertical
        @return role = visible or not visible data
        @return  data in header
        """
        if orientation == QtCore.Qt.Horizontal \
           and role == QtCore.Qt.DisplayRole:
            return self.rootItem.data(section)
        return QtCore.QVariant()

    def index(self, row, column, parent):
        """
        get index item
        @param row = row of needed item
        @param column = cilumn of needed item
        @param parent parent of needed item
        @return  index
        """
        if row < 0 \
            or column < 0 \
            or row >= self.rowCount(parent) \
            or column >= self.columnCount(parent):
            return QtCore.QModelIndex()

        if not parent.isValid():
            parentItem = self.rootItem
        else:
            parentItem = parent.internalPointer()
        childItem = parentItem.child(row)
        if childItem:
            return self.createIndex(row, column, childItem)
        else:
            return QtCore.QModelIndex()

    def parent(self, index):
        """
        get parent                                                                   
        @param index = index of child
        @return index of parent 
        """
        if not index.isValid():
            return QtCore.QModelIndex()
        childItem = index.internalPointer()
        parentItem = childItem.parent()
        if parentItem == self.rootItem:
            return QtCore.QModelIndex()
        return self.createIndex(parentItem.row(), 0, parentItem)

    def rowCount(self, parent):
        """
        get count of row                                                          
        @param parent = parent item
        @return  child count
        """
        if parent.column() > 0:
            return 0
        if not parent.isValid():
            parentItem = self.rootItem
        else:
            parentItem = parent.internalPointer()
        return parentItem.childCount()

    def setupModelData(self, msg, parent):
        """
        fill children item for parent item
        @param msg = comment, from which we get information
        @param parent = root item for next filling
        @return 
        """
        comment_list = msg.comments
        if comment_list:
            for com in comment_list:
                image_label = QtGui.QLabel()
                upic = QtGui.QImage("../data/faviconLJ.ico")
                image_label.setPixmap(QtGui.QPixmap.fromImage(upic))
                columnData = [image_label, com.poster, com.title]
                child = TreeItem(columnData, parent)
                parent.appendChild(child)
                self.setupModelData(com, child)
        else:
            return



class TreeItem:
    """
    Class for getting access in item 
    @version  1.0                                                                  
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru> 
    """
    def __init__(self, data, parent=None):
        """
        initialization item
        @param data = data for item
        @param parent = parent for item
        @return  
        """
        self.parent_item = parent
        self.item_data = data
        self.child_items = []

    def appendChild(self, item):
        """
        add child item
        @param item = child for adding 
        """
        self.child_items.append(item)

    def child(self, row):
        """
        get child in row
        @param row = in this row get item
        @return  item
        """
        return self.child_items[row]

    def childCount(self):
        """
        get count child
        @param 
        @return  quontity of child
        """
        return len(self.child_items)

    def columnCount(self):
        """
        get count column                                                                 
        @param 
        @return  quontity of column
        """
        return len(self.item_data)

    def data(self, column):
        """
        get data item                                                                    
        @param column = column from which data are got
        @return  quontity of child
        """
        return self.item_data[column]

    def parent(self):
        """
        get parent item
        @param 
        @return  parent item
        """
        return self.parent_item

    def row(self):
        """
        get row                                                                    
        @param 
        @return row  
        """
        if self.parent_item:
            return self.parent_item.child_items.index(self)
        return 0



from ViewMessage import *
