#!/usr/bin/env python

"""
===============================================================
    This file contains functions to show posts of out friends
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 9 $"
__date__ = "$Date: 2010/04/04 $"
__copyright__ = ""
__license__ = "GPLv2"

from MainWindow import main_window
from ListMyPosts import ListMyPosts
from ldm.Profile import main_prof
from ScriboExc import WarningExc

class ListFriendsPosts(ListMyPosts):

    def refresh_messages(self):
        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                acc.refresh_friends_page(self.callback)
            except WarningExc, exc:
                main_window.show_warning(exc)

    def get_messages(self):
        return main_prof.get_friends_posts(20)

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = super(ListFriendsPosts, self).create_toolbar()
        self.del_act.setDisabled(True)
        self.del_act.deleteLater()
        return file_tool_bar
