#!/usr/bin/env python

"""
===============================================================
    contains functions to access the database
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 20 $"
__date__ = "$Date: 2010/03/19 $"
__copyright__ = ""
__license__ = "GPLv2"


import os
import sqlite3
import sys

#sys.path.append("..")

from ScriboExc import WarningExc
from Misc import get_home


""" Test SQL-query. Need to determine the first start application """
_SQL_TEST_SELECT = "SELECT max(id) FROM Messages;"
""" Test SQL-query. Need to determine the another application using db """
_SQL_TEST_UPDATE = "UPDATE Messages SET id=1 WHERE id=1;"


"""SQL-query to create a table with user profiles"""
_SQL_CREATE_PROFILES = """CREATE TABLE Profiles (
                                                 id INTEGER PRIMARY KEY , 
                                                 def_account TEXT, 
                                                 misc TEXT
                                                );"""

SQL_PROFILE_FIELDS = [
                      'def_account',
                      'misc'
                     ]

""" SQL-query to create tables with user accounts """
_SQL_CREATE_ACCOUNTS = """CREATE TABLE Accounts (
                                                 id INTEGER PRIMARY KEY, 
                                                 service_id TEXT, 
                                                 username TEXT, 
                                                 passwd TEXT, 
                                                 nick TEXT, 
                                                 path_to_ava TEXT, 
                                                 date_of_birth TEXT, 
                                                 city TEXT, 
                                                 prof TEXT, 
                                                 date TEXT,
                                                 is_group INTEGER, 
                                                 friends TEXT, 
                                                 readers TEXT, 
                                                 journals TEXT, 
                                                 misc TEXT
                                                );"""

SQL_ACCOUNT_FIELDS = [
                      'service_id',
                      'username',
                      'passwd',
                      'nick',
                      'path_to_ava',
                      'date_of_birth',
                      'city',
                      'prof',
                      'date',
                      'is_group',
                      'friends',
                      'readers',
                      'journals',
                      'misc'
                     ]


""" SQL-query to create tables with user messages """
_SQL_CREATE_MESSAGES = """CREATE TABLE Messages (
                                                 id INTEGER PRIMARY KEY, 
                                                 date TEXT, 
                                                 type INTEGER,
                                                 read INTEGER, 
                                                 poster TEXT, 
                                                 journal TEXT,
                                                 path_to_ava TEXT,
                                                 title TEXT,
                                                 text TEXT, 
                                                 parent TEXT, 
                                                 unread_cmnts INTEGER, 
                                                 tags TEXT,
                                                 url TEXT,
                                                 custom_id TEXT,
                                                 misc TEXT
                                                );"""

SQL_MESSAGE_FIELDS = [
                      'date',
                      'type',
                      'read',
                      'poster',
                      'journal',
                      'path_to_ava',
                      'title',
                      'text',
                      'parent',
                      'unread_cmnts',
                      'tags',
                      'url',
                      'custom_id',
                      'misc'
                     ]

TIME_FORMAT = "%Y-%m-%d %H:%M:%S"


class SqlDriver:
    """
    Database driver for SQLite3
    
    @author Mezhenin Artoym <mezhenin@cs.karelia.ru> 
    @version 0.2
    @date 2009/12/08 
    """

    def __init__(self):
        """ 
        Initializes variables   
        """

        self._db = None
        self._cursor = None
        self.open()


    def open(self, db_file=None):
        """
        Open connection to DB. Initialize DB if it don't exists.
        
        @param db_file (string) path to file with DB, None by default 
        @return None
        """
        if not db_file:
            db_file = get_home() + "/db"

        # Check whether the application folder in your home directory
        def_path = os.path.split(db_file)[0]
        if not os.path.exists(def_path):
            os.makedirs(def_path)

        """
        Initialize database
        """
        self._db = sqlite3.connect(db_file)
        self._cursor = self._db.cursor()

        """
        does DB initialized?
        """
        try:
            self._cursor.execute(_SQL_TEST_SELECT)
        except sqlite3.OperationalError:
            """
               Initialize the main tables: Profiles, Accounts, 
            Messages. 
            """
            self.commit_cmd(_SQL_CREATE_PROFILES)
            self.commit_cmd(_SQL_CREATE_ACCOUNTS)
            self.commit_cmd(_SQL_CREATE_MESSAGES)

            """
            Create one record in each table. It is need for selectiong max id
            without errors
            """
            self.commit_cmd("INSERT INTO Profiles (id) VALUES (1);")
            self.commit_cmd("INSERT INTO Messages (id) VALUES (1);")
            self.commit_cmd("INSERT INTO Accounts (id) VALUES (1);")

            #WARNING: we must commit after creating tables
            self._db.commit()

        try:
            self._cursor.execute(_SQL_TEST_UPDATE)
        except sqlite3.OperationalError, exc:
            raise WarningExc('Application is already running', str(exc))


    def close(self):
        """
        Close connection to DB and commit all uncommited changes
        TODO: exceptions try
        """

        try:
            self._db.commit()
            self._cursor.close()
        except sqlite3.ProgrammingError:
            pass

        self._db.close()


    def select_cmd(self, cmd, args=()):
        """
        Execute a query to select a single field from the database (SELECT)
        
        @param cmd (string) SQL-query, in special format
        @param args (tuple) arguments for query
        @return (string) first field of the first row of reply 
                    or WarningExc
        """

        self._cursor.execute(cmd, args)
        one = self._cursor.fetchone()
        if one:
            return one[0]
        else:
            raise WarningExc("SqlDriver", "no data match")



    def select_mcmd(self, cmd, args=()):
        """
        Execute a query and fetch all fields (SELECT all fields)
        
        @param cmd (string) SQL-query, in special format
        @param args (tuple) arguments for query
        @return a tuple of lines derived from the database or WarningExc
        """

        self._cursor.execute(cmd, args)
        return self._cursor.fetchall()


    def commit_cmd(self, cmd, args=()):
        """
        Execute query to change data in the database (INSERT, DELETE, UPDATE)   
        
        @param cmd (string) SQL-query, in special format
        @param args (tuple) arguments for query
        @return None, WarningExc
        """

        self._cursor.execute(cmd, args)
        #self._db.commit()


sql_driver = SqlDriver()
