#!/usr/bin/env python
"""
 @file: ViewMessage.py
  File is a part of Scribo Project
  Module implements viewing post or comment for user
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 06.01.2010
"""
import sys

from PyQt4 import QtCore
from PyQt4 import QtGui
from PyQt4.QtWebKit import *

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow

from ldm.Message import Message
from ldm.Profile import main_prof
from ldm.Account import Account

from ScriboExc import WarningExc

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/01/06 $"
__copyright__ = ""
__license__ = "GPLv2"

class ViewMessage(ToolbarWindow):
    """
    class for drawing window viewing post or comments
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  all hanglers
    """
    def __init__(self, parent=None, msg="default"):
        """ 
        initialization viewing window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.msg = msg
        msg.read = True
        self.create_actions()
        toolbar = self.create_toolbar()
        self.list = main_prof.get_posts()
        self.vbox = QtGui.QVBoxLayout()

        key = self.list.index(self.msg)
        if key < 1:
            self.up_act.setDisabled(True)
        if key > len(self.list) - 2:
            self.down_act.setDisabled(True)

        self.view_mes_widget = QWebView(self)
        self.view_mes(msg)
        self.view_mes_widget.show()
        self.vbox.addWidget(toolbar)
        self.vbox.addWidget(self.view_mes_widget)
        self.setLayout(self.vbox)


    def view_mes(self, msg):
        """ 
        fill webkit widget                                                   
        @param msg - id message for viewing                                         
        @return web_mes_widg - webkit widget with title, date, text message
        and its parent message 
        """
        #web = QWebView(self)
        title = msg.title
        text = msg.text
        user = msg.poster
        date = msg.date
        parent = msg.parent
        tags = msg.tags

        if user:
            author = user.nick
        if not author:
            author = ""

        if not title:
            title = ""
        if not tags:
            tags = ""
        if not text:
            text = ""
        if not date:
            date = ""

        parent_text = ""
        if parent:
            parent_text = parent.text
        if not parent_text:
            parent_text = ""
        # check on javascript injection    
        text = self.text_escape(text)
        parent_text = self.text_escape(parent_text)
        title = self.text_escape(title)
        tags = self.text_escape(tags)
        text = self.text_br(text)

        self.view_mes_widget.setHtml("<head><meta http-equiv=\"Content-Type\" \
                    content=\"text/html; charset=utf-8\" /> \
                    </head> <h3><a href = \"scribo://parent\">\
                    Parrent:</a></h3>" + parent_text +
                    "<h3><font color=\"green\">\
                    Comment:</font> </h3><b>Title: </b>" + title +
                    "<br/> <b> Author: </b>" + author +
                    "<br/><b> Date: </b>" + date + "<br/><b> Tags: </b>"
                    + tags + "<br/>" "<b> Text:\
                    </b><br />" + text + "<br/>")

        del(title)
        del(text)
        del(user)
        del(date)
        del(parent)



    def text_escape(self, text):
        """
        check on javascript injection    
        @param text = text which is checked
        @return text = escaped text(if it is need)
        """
        js = QtCore.QRegExp("(<script>|javascript:|<script)")
        js.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        pos = js.indexIn(unicode(text))
        cap = js.capturedTexts()
        for i in xrange(cap.count()):
            if cap[i] <> "":
                import cgi
                return cgi.escape(unicode(text))
        return text

    def text_br(self, text):
        str = QtCore.QString(text)
        str.replace("/n", "<br />")
        return str

    def create_toolbar(self):
        """
        create toolbar for window
        @return
        """
        file_tool_bar = QtGui.QToolBar("", self)
        file_tool_bar.setIconSize(QtCore.QSize(64, 64))
        file_tool_bar.addAction(self.back_act)
        file_tool_bar.addAction(self.home_act)
        #file_tool_bar.addAction(self.refresh_act)
        file_tool_bar.addAction(self.up_act)
        file_tool_bar.addAction(self.down_act)
        file_tool_bar.addAction(self.edit_act)
        if not self.msg.is_editable():
            self.edit_act.setDisabled(True)
        #file_tool_bar.addAction(self.tree_act)

        return file_tool_bar


    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        """
        self.refresh_act = QtGui.QAction(self.tr("&Refresh"), self)
        self.refresh_act.setStatusTip(self.tr("Refresh"))
        self.refresh_act.setIcon(QtGui.QIcon("../data/refresh.png"))
        self.connect(self.refresh_act, QtCore.SIGNAL("triggered()"),
                     self.refresh_mes)
        """
        self.up_act = QtGui.QAction(self.tr("&Previous"), self)
        #self.up_act.setStatusTip(self.tr("Previous message"))
        self.up_act.setIcon(QtGui.QIcon("../data/prev.png"))
        self.connect(self.up_act, QtCore.SIGNAL("activated()"),
                     self.view_prev_message)

        self.down_act = QtGui.QAction(self.tr("&Next"), self)
        #self.down_act.setStatusTip(self.tr("Next message"))
        self.down_act.setIcon(QtGui.QIcon("../data/next.png"))
        self.connect(self.down_act, QtCore.SIGNAL("activated()"),
                     self.view_next_message)
        #don't realized
        """
        self.comment_act = QtGui.QAction(self.tr("&Comment"), self)
        self.comment_act.setStatusTip(self.tr("Write comment"))
        self.comment_act.setIcon(QtGui.QIcon("../data/add_post.png"))
        self.connect(self.comment_act, QtCore.SIGNAL("activated()"),
                     self.write_comment)
        """
        self.edit_act = QtGui.QAction(self.tr("&Edit"), self)
        #self.edit_act.setStatusTip(self.tr("Edit"))
        self.edit_act.setIcon(QtGui.QIcon("../data/add_post.png"))
        self.connect(self.edit_act, QtCore.SIGNAL("activated()"),
                     self.edit_post)

        self.tree_act = QtGui.QAction(self.tr("&Tree comments"), self)
        #self.tree_act.setStatusTip(self.tr("Tree of comments"))
        self.tree_act.setIcon(QtGui.QIcon("../data/tree.png"))
        self.connect(self.tree_act, QtCore.SIGNAL("activated()"),
                     self.tree_comments)

        super(ViewMessage, self).create_actions()

    def view_prev_message(self):
        """
        change viewing message on prev
        @param
        @return                                              
        """

        key = self.list.index(self.msg)
        if key <= 1:
            self.up_act.setDisabled(True)
        if key > 0:
            self.down_act.setDisabled(False)
            self.msg = self.list[key - 1]
            if not self.msg.is_editable():
                self.edit_act.setDisabled(True)
            else:
                self.edit_act.setDisabled(False)
            self.reload_window()


    def view_next_message(self):
        """
        change viewing message on next
        @param
        @return                                            
        """

        key = self.list.index(self.msg)
        if key >= len(self.list) - 2:
            self.down_act.setDisabled(True)
        if key < len(self.list) - 1:
            self.up_act.setDisabled(False)
            self.msg = self.list[key + 1]
            if not self.msg.is_editable():
                self.edit_act.setDisabled(True)
            else:
                self.edit_act.setDisabled(False)
            self.reload_window()

    def write_comment(self):
        """
        window with field for writing comment
        @param
        @return                                          
        """
        pass

    def edit_post(self):
        """
        window with field for editing post
        @param
        @return                                          
        """
        edit_widg = AddPostWindow(parent=main_window, msg=self.msg)
        main_window.push_window(edit_widg)


    def tree_comments(self):
        """
        window with tree message
        @param
        @return                                                      
        """
        tree_widg = TreeMessage(main_window, self.msg)
        main_window.push_window(tree_widg)


    def reload_window(self):
        """
        reload window with current message
        @param
        @return                                                                  
        """
        #self.vbox.removeWidget(self.view_mes_widget)
        #self.view_mes_widget = 
        self.msg.read = True
        self.view_mes(self.msg)
        self.view_mes_widget.show()
        #self.vbox.addWidget(self.view_mes_widget)

    def refresh_mes(self):
        """
        reload message
        @param
        @return                                                                  
        """
        acc = self.msg.journal
        try:
            acc.refresh_posts(self.callback)
        except WarningExc, exc:
            #setSelected(select)
            main_window.show_warning(exc)
        else:
            self.reload_window()

    def callback(self):
        print "!!!"


from TreeMessage import *
from AddPost import *

