#!/usr/bin/env python

"""
===============================================================
    Module for testing of structure class
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 3 $"
__date__ = "$Date: 2010/02/07 $"
__copyright__ = ""
__license__ = "GPLv2"

import unittest
import sys
sys.path.append("..")
sys.path.append("../ldm")

from Structure import Structure
from ScriboExc import WarningExc


class StructureTest(unittest.TestCase):
    """
    Class with test method for Structure module
    """

    def setUp(self):
        """
        Init variables for test methods
        """
        self.msg = Structure("Messages")


    def test_field(self):
        """
        test for Structure._get_field and  Structure._set_field
        save text in DB and load it 
        """
        self.assertEqual(self.msg._get_field("text"), None)
        self.msg._set_field("text", "Hello World!")
        self.assertEqual(self.msg._get_field("text"), "Hello World!")


    def test_del_struct(self):
        """
        test for Structure._del_struct
        delete object from DB and trying to load it
        """
        id = self.msg.id
        self.msg._del_struct()
        self.assertRaises(WarningExc, Structure, "Messages", id)


    def test_init(self):
        """
        test for Structure.__init__
        check id assignment for new and existiong objects
        """
        id1 = self.msg.id
        msg2 = Structure("Messages")
        self.assertNotEqual(id1, msg2.id)
        msg3 = Structure("Messages", id1)
        self.assertEqual(id1, msg3.id)


    def test_eq(self):
        """
        test for Structure.__eq__
        compare objects with differenet id or/and table name
        """
        msg2 = Structure("Messages")
        self.assertNotEqual(self.msg, msg2)
        msg3 = Structure("Messages", self.msg.id)
        self.assertEqual(self.msg, msg3)
        acc = Structure("Accounts")
        self.assertNotEqual(self.msg, acc)


    def test_id(self):
        """
        test for Structure.id(get)id())
        check type and value of id
        """
        self.assertEqual(self.msg.get_id(), self.msg.id)
        self.assertEqual(int, type(self.msg.id))
        self.assertTrue(self.msg.id > 0)
        try:
            self.msg.id = 909
        except AttributeError:
            pass
        else:
            self.fail()


    def test_misc(self):
        """
        test for Structure.misc(get_ and set_)
        run methods with wrong params, check saved dictionary
        """
        self.assertEqual(type(self.msg.misc), dict)
        self.assertEqual(self.msg.misc, self.msg.get_misc())
        self.assertRaises(WarningExc, self.msg.set_misc, 777)
        self.msg.misc = {"777": "some text"}
        self.assertEqual(self.msg.get_misc(), {"777": "some text"})


    def test_options(self):
        """
        test for Structure.get_option,  Structure.set_option
        add new options,  change their value and type 
        """
        self.assertRaises(KeyError,
                          self.msg.get_option,
                          "you don't have this option9817342-503547923")

        self.msg.set_option("new_option", 777)
        self.assertEqual(777, self.msg.get_option("new_option"))

        self.msg.set_option("new_option", "777")
        self.assertNotEqual(777, self.msg.get_option("new_option"))
        self.assertEqual("777", self.msg.get_option("new_option"))

        self.msg.set_option("list_", [1, 4, "frha"])
        self.assertEqual(list, type(self.msg.get_option("list_")))


if __name__ == '__main__':
    unittest.main()


