#!/usr/bin/env python
#@file: build.py
#This script install Scribo project 
#@author: Alexander Sannikov <sannikov@cs.karelia.ru>
#@date: 5.12.2009
 
import glob
from distutils.core import setup
#set metadata
dname = "Scribo"
dversion = '2.0'
dauthor = "Dyana Zaiceva, Mezhenyn Artyom, Sannikov Alexander, Germanov Kyrill"
durl = "http://oss.fruct.org/"
ddescription = "Cross-blog client for Maemo"
dlong_description = """

"""
dscripts = ["scribo.py",]
platforms = ['Maemo']
dlicense = "GPLv2"
cf = (
            "Development Status :: 5 - Production/Stable",
            "Environment :: X11 Applications :: Qt",
            "Intended Audience :: End Users/Desktop",
            "License :: OSI Approved :: GNU General Public License (GPL)",
            "Natural Language :: English",
            "Operating System :: POSIX :: Other:",
            "Programming Language :: Python :: 2",
            "Topic :: Internet :: WWW/HTTP",
            )
            
#get files for setup
desktop_file = ['scribo.desktop']
main_script = ['scribo.py']
pixmaps = glob.glob('data/*.png')+glob.glob('data/*.ico')

src_scripts = glob.glob('src/*.py')
src_scripts = src_scripts + glob.glob('src/ui/*.py')
src_scripts = src_scripts + glob.glob('src/test/*.py')
src_scripts = src_scripts + glob.glob('src/ldm/*.py')
src_scripts = src_scripts + glob.glob('src/Dispatcher/*.py')
src_scripts = src_scripts + glob.glob('src/scripts/*.py')
dbus_serv = ['scribo.service']
icon = ['data/Scribo.png']
deps = ['sqlite3','xmlrpclib','PySide']

#setup project
setup(
      name=dname,
      version=dversion,
      description=ddescription,
      long_description=dlong_description,
      author=dauthor,
      url=durl,
      scripts=dscripts,
      classifiers=cf,
      license=dlicense,
      requires=deps
      )