#!/usr/bin/env python
#@file: build.py
#This script build deb-package for Scribo project 
#@author: Alexander Sannikov <sannikov@cs.karelia.ru>
#@date: 10.12.2009

import glob
import py2deb
import os
import sys

from src.About import __version__ as v
version = v
 
build = "747"

#setup puckage meta-info
#changelogi = open("changelog", "r").read()
p = py2deb.Py2deb("scribo")
p.description = """
Cross-blog client for Maemo
This version is alpha, so it is not recommended for usual users.
But if you want to help project you can try to use application.
Please send bugs to scribo@cs.karelia.ru.

In future local cache module can be changed so you must remove all application
data from ~/.scribo before installation of new version. 
Use "cd ~; rm -rf ./.scribo" for this.

Thank you.
"""
#p.license = "gpl"
p.depends = "python, sqlite3, python-xml, pyside-qt4, pyside-qt4-webkit, pyside-qt4-gui, python-dbus"
p.section = "other"
p.arch = "all"
p.url = "http://oss.fruct.org/"
p.author = "Zaiceva Dyana, Mezhenyn Artyom, Sannikov Alexander, Germanov Kyrill"
p.xsbc_bugtracker = "http://oss.fruct.org/bugzilla/"
p.repository = "extras-devel"
p.distribution = "fremantle"
p.urgency = "low"
p.mail = "<scribo@cs.karelia.ru>"
#p.postinstall = """chmod +x /usr/bin/scribo; exit 0"""

#setup paths for files
p["/usr/bin"] = ["scribo|scribo", ]
p["/usr/share/doc/scribo"] = ["README", "copying", "NEWS", "TODO", ]

#setup data and icons files
p.postinstall="""#!/bin/sh
  chmod +x /usr/bin/scribo; exit 0""" 

icons = [i + "|" + i[5:] for i in glob.glob('data/*.png') + glob.glob('data/*.ico')]
p["/opt/scribo/data"] = icons
p.icon = "data/Scribo.png"

src_scripts = glob.glob('src/*.py')
p["/opt/scribo/src"] = [i + "|" + i[4:] for i in src_scripts]

src_scripts = glob.glob('src/ui/*.py')
p["/opt/scribo/src/ui"] = [i + "|" + i[7:] for i in src_scripts]

src_scripts = glob.glob('src/bugz/*.py')
p["/opt/scribo/src/bugz"] = [i + "|" + i[9:] for i in src_scripts]

src_scripts = glob.glob('src/ldm/*.py')
p["/opt/scribo/src/ldm"] = [i + "|" + i[8:] for i in src_scripts]

src_scripts = glob.glob('src/services/*.py')
p["/opt/scribo/src/services"]= [i + "|" + i[13:] for i in src_scripts]

p["/usr/share/applications/hildon"] = ['scribo.desktop',]
p["/usr/share/dbus-1/services"] = ['scribo.service',]
changeloginformation = "Fixed (large) icon."

#buid deb
print p

p.generate(version, build, changelog=changeloginformation, tar=True, dsc=True, changes=True, build=False, src=True)
#p.generate(version, "0.2.1", changelog="test", rpm=False, src=True)


