/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _TIME_FRAME_SELECTION_H
#define _TIME_FRAME_SELECTION_H
#include <gtk/gtk.h>
#include <hildon/hildon.h>

enum
{
  SEARCH_ALL = 0,
  SEARCH_THIS_DAY,
  SEARCH_THIS_WEEK,
  SEARCH_THIS_MONTH,
  SEARCH_THIS_YEAR,
  SEARCH_UPTO_TODAY,
  SEARCH_CUSTOM_INTERVAL,
};

struct _search_time_settings_t
{
  gint search_type;
  time_t start_time;
  time_t end_time;
};

typedef _search_time_settings_t search_time_settings_t;

gchar*
time_frame_value_str(search_time_settings_t* settings);

void
show_time_selection_dialog(GtkButton* button, gpointer user_data);
#endif
