/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _CALENDAR_SEARCH_SETTINGS_H_
#define _CALENDAR_SEARCH_SETTINGS_H_
#include "config.h"

#include <glib.h>
#include <gtk/gtk.h>	
#include <gconf/gconf-client.h>	

#define GC_ROOT "/apps/maemo/" PACKAGE 
#define GCONF_CALENDAR_SEARCH_SETTINGS GC_ROOT "/calendar_search_settings"

#define GCONF_CALENDAR_SETTINGS_SEARCH_EVENTS GCONF_CALENDAR_SEARCH_SETTINGS "/search_events"
#define GCONF_CALENDAR_SETTINGS_SEARCH_TASKS GCONF_CALENDAR_SEARCH_SETTINGS "/search_tasks"
#define GCONF_CALENDAR_SETTINGS_SEARCH_NOTES GCONF_CALENDAR_SEARCH_SETTINGS "/search_notes"
#define GCONF_CALENDAR_SETTINGS_SEARCH_BIRTHDAYS GCONF_CALENDAR_SEARCH_SETTINGS "/search_birthdays"
#define GCONF_CALENDAR_SETTINGS_NUM_CALENDARS GCONF_CALENDAR_SEARCH_SETTINGS "/num_calendars"
#define GCONF_CALENDAR_SETTINGS_CALENDAR_IDS GCONF_CALENDAR_SEARCH_SETTINGS "/calendar_ids"
#define GCONF_CALENDAR_SETTINGS_SEARCH_TYPE GCONF_CALENDAR_SEARCH_SETTINGS "/search_type"
#define GCONF_CALENDAR_SETTINGS_SEARCH_START_TIME GCONF_CALENDAR_SEARCH_SETTINGS "/search_start_time"
#define GCONF_CALENDAR_SETTINGS_SEARCH_END_TIME GCONF_CALENDAR_SEARCH_SETTINGS "/search_end_time"

struct _calendar_search_settings_t
{
  gboolean search_events;
  gboolean search_tasks;
  gboolean search_notes;
  gboolean search_birthdays;
  gint num_calendars;
  gint* calendar_ids;
  gint search_type;
  time_t start_time;
  time_t end_time;
};

typedef _calendar_search_settings_t calendar_search_settings_t;

void
show_calendar_id_selection_dlg(GtkButton* button, gpointer user_data);

void
show_calendar_search_settings_dlg(GtkButton* button, gpointer user_data);

void
calendar_search_settings_read(GConfClient* client, calendar_search_settings_t* calendar_search_settings);

#endif
