/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        mapdata.h ( Save Scummer Library, C++ )
 *
 * COMMENTS:
 *	Contains an array of u8s which can be copy-on-writed.
 */

#ifndef __mapdata__
#define __mapdata__

#include "mygba.h"

class MAPDATA_REF;

class MAPDATA
{
public:
		 MAPDATA();
    explicit	 MAPDATA(int nbytes);
		 MAPDATA(const MAPDATA &data);
    
    virtual	~MAPDATA();

    MAPDATA 	&operator=(const MAPDATA &data);

    u8		 operator()(int i) const;
    u8		&operator()(int i);

    const u8	*readData() const;
    u8		*writeData();

private:
    MAPDATA_REF	*myRef;
};

#endif

