/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        worldstate.h ( Save Scummer Library, C++ )
 *
 * COMMENTS:
 */

#ifndef __worldstate__
#define __worldstate__

#include "dpdf.h"
#include "glbdef.h"

class MAP;

class WORLDSTATE
{
public:
    // We use reference counting as each save state will store
    // the entire history of the world at that save point.  With the
    // use of back/forward time, we can easily end up with a tree
    // branching of worldstates, so it would be a good thing to ensure
    // the common ancestors are merged.
    void	incRef();
    void	decRef();
	     
    // Reads the worlds state and creates a new WORLDSTATE that represents
    // it.  The returned worldstate has already been incRefed.
    static WORLDSTATE   *pushState(MAP *mainmap);
    // Takes this WORLDSTATE and writes it out to our actual world state.
    MAP 		*popState();

    // Save and load the world state.
    // TBD
private:
	     WORLDSTATE();
    virtual ~WORLDSTATE();

public:
    MAP		*myMainMap;
    int		 myScore;
    int		 myTime;
    int		 myHistory;
    DPDF	 myAvatarHP_DPDF;

    // Avatar stats
    // These are the only varying stats...
    int		 myAvatarMP;
    int		 myAvatarHP;	// Not varying, but convenient!
    int		 myAvatarProbExp;
    double	 myAvatarProb;

    int		 myRef;
};

#endif

